/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.MessageStatusUser;

/**
 * Holds the status of a particular message, indicating which user the message has been sent, delivered or read. 
 */
@ApiModel(description = "Holds the status of a particular message, indicating which user the message has been sent, delivered or read. ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class MessageStatus {
  @JsonProperty("read")
  private List<MessageStatusUser> read = null;

  @JsonProperty("delivered")
  private List<MessageStatusUser> delivered = null;

  @JsonProperty("sent")
  private List<MessageStatusUser> sent = null;

  public MessageStatus read(List<MessageStatusUser> read) {
    this.read = read;
    return this;
  }

  public MessageStatus addReadItem(MessageStatusUser readItem) {
    if (this.read == null) {
      this.read = new ArrayList<MessageStatusUser>();
    }
    this.read.add(readItem);
    return this;
  }

   /**
   * All users who have read that message, in any Symphony client.
   * @return read
  **/
  @ApiModelProperty(value = "All users who have read that message, in any Symphony client.")
  public List<MessageStatusUser> getRead() {
    return read;
  }

  public void setRead(List<MessageStatusUser> read) {
    this.read = read;
  }

  public MessageStatus delivered(List<MessageStatusUser> delivered) {
    this.delivered = delivered;
    return this;
  }

  public MessageStatus addDeliveredItem(MessageStatusUser deliveredItem) {
    if (this.delivered == null) {
      this.delivered = new ArrayList<MessageStatusUser>();
    }
    this.delivered.add(deliveredItem);
    return this;
  }

   /**
   * All users who have at least one Symphony client to which the message has been delivered, and not read yet. 
   * @return delivered
  **/
  @ApiModelProperty(value = "All users who have at least one Symphony client to which the message has been delivered, and not read yet. ")
  public List<MessageStatusUser> getDelivered() {
    return delivered;
  }

  public void setDelivered(List<MessageStatusUser> delivered) {
    this.delivered = delivered;
  }

  public MessageStatus sent(List<MessageStatusUser> sent) {
    this.sent = sent;
    return this;
  }

  public MessageStatus addSentItem(MessageStatusUser sentItem) {
    if (this.sent == null) {
      this.sent = new ArrayList<MessageStatusUser>();
    }
    this.sent.add(sentItem);
    return this;
  }

   /**
   * All users to whom the message has been sent and received by the Symphony system, but not yet delivered to any user&#39;s Symphony client. 
   * @return sent
  **/
  @ApiModelProperty(value = "All users to whom the message has been sent and received by the Symphony system, but not yet delivered to any user's Symphony client. ")
  public List<MessageStatusUser> getSent() {
    return sent;
  }

  public void setSent(List<MessageStatusUser> sent) {
    this.sent = sent;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessageStatus messageStatus = (MessageStatus) o;
    return Objects.equals(this.read, messageStatus.read) &&
        Objects.equals(this.delivered, messageStatus.delivered) &&
        Objects.equals(this.sent, messageStatus.sent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(read, delivered, sent);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessageStatus {\n");
    
    sb.append("    read: ").append(toIndentedString(read)).append("\n");
    sb.append("    delivered: ").append(toIndentedString(delivered)).append("\n");
    sb.append("    sent: ").append(toIndentedString(sent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

