/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.ApplicationInfo;

/**
 * Detailed record of application.
 */
@ApiModel(description = "Detailed record of application.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class ApplicationDetail {
  @JsonProperty("applicationInfo")
  private ApplicationInfo applicationInfo = null;

  @JsonProperty("iconUrl")
  private String iconUrl = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("allowOrigins")
  private String allowOrigins = null;

  @JsonProperty("permissions")
  private List<String> permissions = null;

  @JsonProperty("cert")
  private String cert = null;

  public ApplicationDetail applicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
    return this;
  }

   /**
   * Get applicationInfo
   * @return applicationInfo
  **/
  @ApiModelProperty(value = "")
  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }

  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }

  public ApplicationDetail iconUrl(String iconUrl) {
    this.iconUrl = iconUrl;
    return this;
  }

   /**
   * Url to a icon to use for app. Must start with \&quot;https://\&quot;.
   * @return iconUrl
  **/
  @ApiModelProperty(value = "Url to a icon to use for app. Must start with \"https://\".")
  public String getIconUrl() {
    return iconUrl;
  }

  public void setIconUrl(String iconUrl) {
    this.iconUrl = iconUrl;
  }

  public ApplicationDetail description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Description of the application.
   * @return description
  **/
  @ApiModelProperty(value = "Description of the application.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ApplicationDetail allowOrigins(String allowOrigins) {
    this.allowOrigins = allowOrigins;
    return this;
  }

   /**
   * The permitted domains to send or receive a request from. The field is for the purpose of CORS which set the app specific \&quot;ALLOW-ORIGIN-DOMAINS\&quot; header in HTTP. 
   * @return allowOrigins
  **/
  @ApiModelProperty(value = "The permitted domains to send or receive a request from. The field is for the purpose of CORS which set the app specific \"ALLOW-ORIGIN-DOMAINS\" header in HTTP. ")
  public String getAllowOrigins() {
    return allowOrigins;
  }

  public void setAllowOrigins(String allowOrigins) {
    this.allowOrigins = allowOrigins;
  }

  public ApplicationDetail permissions(List<String> permissions) {
    this.permissions = permissions;
    return this;
  }

  public ApplicationDetail addPermissionsItem(String permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<String>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

   /**
   * List of application permissions provisioned for the application Accepted values:   - SEND_MESSAGES   - GET_USER_CONNECTIONS   - REQUEST_USER_CONNECTIONS   - SET_PRESENCE   - GET_PRESENCE   - GET_BASIC_USER_INFO   - GET_EXTENDED_USER_INFO   - GET_BASIC_CONTACT_INFO   - GET_EXTENDED_CONTACT_INFO   - ACT_AS_USER 
   * @return permissions
  **/
  @ApiModelProperty(value = "List of application permissions provisioned for the application Accepted values:   - SEND_MESSAGES   - GET_USER_CONNECTIONS   - REQUEST_USER_CONNECTIONS   - SET_PRESENCE   - GET_PRESENCE   - GET_BASIC_USER_INFO   - GET_EXTENDED_USER_INFO   - GET_BASIC_CONTACT_INFO   - GET_EXTENDED_CONTACT_INFO   - ACT_AS_USER ")
  public List<String> getPermissions() {
    return permissions;
  }

  public void setPermissions(List<String> permissions) {
    this.permissions = permissions;
  }

  public ApplicationDetail cert(String cert) {
    this.cert = cert;
    return this;
  }

   /**
   * The app public certificate in pem format.
   * @return cert
  **/
  @ApiModelProperty(value = "The app public certificate in pem format.")
  public String getCert() {
    return cert;
  }

  public void setCert(String cert) {
    this.cert = cert;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationDetail applicationDetail = (ApplicationDetail) o;
    return Objects.equals(this.applicationInfo, applicationDetail.applicationInfo) &&
        Objects.equals(this.iconUrl, applicationDetail.iconUrl) &&
        Objects.equals(this.description, applicationDetail.description) &&
        Objects.equals(this.allowOrigins, applicationDetail.allowOrigins) &&
        Objects.equals(this.permissions, applicationDetail.permissions) &&
        Objects.equals(this.cert, applicationDetail.cert);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applicationInfo, iconUrl, description, allowOrigins, permissions, cert);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationDetail {\n");
    
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    iconUrl: ").append(toIndentedString(iconUrl)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    allowOrigins: ").append(toIndentedString(allowOrigins)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    cert: ").append(toIndentedString(cert)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

