package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.CompanyCert;
import org.symphonyoss.symphony.pod.model.CompanyCertAttributes;
import org.symphonyoss.symphony.pod.model.CompanyCertDetail;
import org.symphonyoss.symphony.pod.model.CompanyCertInfoList;
import org.symphonyoss.symphony.pod.model.CompanyCertTypeList;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.StringId;
import org.symphonyoss.symphony.pod.model.SuccessResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class SecurityApi {
  private ApiClient apiClient;

  public SecurityApi() {
    this(Configuration.getDefaultApiClient());
  }

  public SecurityApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create a company trusted or untrusted certificate
   * 
   * @param sessionToken Session authentication token. (required)
   * @param cert  (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1CompanycertCreatePost(String sessionToken, CompanyCert cert) throws ApiException {
    Object localVarPostBody = cert;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1CompanycertCreatePost");
    }
    
    // verify the required parameter 'cert' is set
    if (cert == null) {
      throw new ApiException(400, "Missing the required parameter 'cert' when calling v1CompanycertCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/companycert/create";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete a company certificate
   * 
   * @param sessionToken Session authentication token. (required)
   * @param fingerPrint  (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1CompanycertDeletePost(String sessionToken, StringId fingerPrint) throws ApiException {
    Object localVarPostBody = fingerPrint;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1CompanycertDeletePost");
    }
    
    // verify the required parameter 'fingerPrint' is set
    if (fingerPrint == null) {
      throw new ApiException(400, "Missing the required parameter 'fingerPrint' when calling v1CompanycertDeletePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/companycert/delete";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the details of a company certificate
   * 
   * @param fingerPrint Certificate fingerPrint (ID) (required)
   * @param sessionToken Session authentication token. (required)
   * @return CompanyCertDetail
   * @throws ApiException if fails to make API call
   */
  public CompanyCertDetail v1CompanycertFingerPrintGetGet(String fingerPrint, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'fingerPrint' is set
    if (fingerPrint == null) {
      throw new ApiException(400, "Missing the required parameter 'fingerPrint' when calling v1CompanycertFingerPrintGetGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1CompanycertFingerPrintGetGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/companycert/{fingerPrint}/get"
      .replaceAll("\\{" + "fingerPrint" + "\\}", apiClient.escapeString(fingerPrint.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<CompanyCertDetail> localVarReturnType = new GenericType<CompanyCertDetail>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Return a list of all certificates which were verified to the cert whose fingerprint is passed. 
   * 
   * @param fingerPrint Certificate fingerPrint (ID) (required)
   * @param sessionToken Session authentication token. (required)
   * @return CompanyCertInfoList
   * @throws ApiException if fails to make API call
   */
  public CompanyCertInfoList v1CompanycertFingerPrintIssuedByGet(String fingerPrint, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'fingerPrint' is set
    if (fingerPrint == null) {
      throw new ApiException(400, "Missing the required parameter 'fingerPrint' when calling v1CompanycertFingerPrintIssuedByGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1CompanycertFingerPrintIssuedByGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/companycert/{fingerPrint}/issuedBy"
      .replaceAll("\\{" + "fingerPrint" + "\\}", apiClient.escapeString(fingerPrint.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<CompanyCertInfoList> localVarReturnType = new GenericType<CompanyCertInfoList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update a company certificate
   * 
   * @param fingerPrint Certificate fingerPrint (ID) (required)
   * @param sessionToken Session authentication token. (required)
   * @param certAttributes  (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1CompanycertFingerPrintUpdatePost(String fingerPrint, String sessionToken, CompanyCertAttributes certAttributes) throws ApiException {
    Object localVarPostBody = certAttributes;
    
    // verify the required parameter 'fingerPrint' is set
    if (fingerPrint == null) {
      throw new ApiException(400, "Missing the required parameter 'fingerPrint' when calling v1CompanycertFingerPrintUpdatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1CompanycertFingerPrintUpdatePost");
    }
    
    // verify the required parameter 'certAttributes' is set
    if (certAttributes == null) {
      throw new ApiException(400, "Missing the required parameter 'certAttributes' when calling v1CompanycertFingerPrintUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/companycert/{fingerPrint}/update"
      .replaceAll("\\{" + "fingerPrint" + "\\}", apiClient.escapeString(fingerPrint.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * List all trusted certs
   * 
   * @param sessionToken Session authentication token. (required)
   * @param skip Pagination start (optional)
   * @param limit Row limit (optional)
   * @return CompanyCertInfoList
   * @throws ApiException if fails to make API call
   */
  public CompanyCertInfoList v1CompanycertListGet(String sessionToken, Integer skip, Integer limit) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1CompanycertListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/companycert/list";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "skip", skip));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<CompanyCertInfoList> localVarReturnType = new GenericType<CompanyCertInfoList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * List all trusted certs
   * 
   * @param sessionToken Session authentication token. (required)
   * @param skip Pagination start (optional)
   * @param limit Row limit (optional)
   * @return CompanyCertInfoList
   * @throws ApiException if fails to make API call
   */
  public CompanyCertInfoList v1CompanycertPodmanagedListGet(String sessionToken, Integer skip, Integer limit) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1CompanycertPodmanagedListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/companycert/podmanaged/list";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "skip", skip));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<CompanyCertInfoList> localVarReturnType = new GenericType<CompanyCertInfoList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * List all certs of the given types
   * 
   * @param typeIdList Certificate type list (required)
   * @param sessionToken Session authentication token. (required)
   * @param skip Pagination start (optional)
   * @param limit Row limit (optional)
   * @return CompanyCertInfoList
   * @throws ApiException if fails to make API call
   */
  public CompanyCertInfoList v1CompanycertTypeListPost(CompanyCertTypeList typeIdList, String sessionToken, Integer skip, Integer limit) throws ApiException {
    Object localVarPostBody = typeIdList;
    
    // verify the required parameter 'typeIdList' is set
    if (typeIdList == null) {
      throw new ApiException(400, "Missing the required parameter 'typeIdList' when calling v1CompanycertTypeListPost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1CompanycertTypeListPost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/companycert/type/list";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "skip", skip));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<CompanyCertInfoList> localVarReturnType = new GenericType<CompanyCertInfoList>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Create a company trusted or untrusted certificate. Different from V1 in that we reject expired certificates.
   * 
   * @param sessionToken Session authentication token. (required)
   * @param cert  (required)
   * @return CompanyCertDetail
   * @throws ApiException if fails to make API call
   */
  public CompanyCertDetail v2CompanycertCreatePost(String sessionToken, CompanyCert cert) throws ApiException {
    Object localVarPostBody = cert;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v2CompanycertCreatePost");
    }
    
    // verify the required parameter 'cert' is set
    if (cert == null) {
      throw new ApiException(400, "Missing the required parameter 'cert' when calling v2CompanycertCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v2/companycert/create";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<CompanyCertDetail> localVarReturnType = new GenericType<CompanyCertDetail>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
