package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.MessageStatus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class MessageApi {
  private ApiClient apiClient;

  public MessageApi() {
    this(Configuration.getDefaultApiClient());
  }

  public MessageApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get the read status of a particular message.
   * 
   * @param mid Message ID (required)
   * @param sessionToken Session authentication token. (required)
   * @return MessageStatus
   * @throws ApiException if fails to make API call
   */
  public MessageStatus v1MessageMidStatusGet(String mid, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'mid' is set
    if (mid == null) {
      throw new ApiException(400, "Missing the required parameter 'mid' when calling v1MessageMidStatusGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1MessageMidStatusGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/message/{mid}/status"
      .replaceAll("\\{" + "mid" + "\\}", apiClient.escapeString(mid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MessageStatus> localVarReturnType = new GenericType<MessageStatus>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
