package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.SuccessResponse;
import org.symphonyoss.symphony.pod.model.UserConnection;
import org.symphonyoss.symphony.pod.model.UserConnectionList;
import org.symphonyoss.symphony.pod.model.UserConnectionRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class ConnectionApi {
  private ApiClient apiClient;

  public ConnectionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ConnectionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Accept the connection request for the requesting user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param connectionRequest  (required)
   * @return UserConnection
   * @throws ApiException if fails to make API call
   */
  public UserConnection v1ConnectionAcceptPost(String sessionToken, UserConnectionRequest connectionRequest) throws ApiException {
    Object localVarPostBody = connectionRequest;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionAcceptPost");
    }
    
    // verify the required parameter 'connectionRequest' is set
    if (connectionRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'connectionRequest' when calling v1ConnectionAcceptPost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/connection/accept";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserConnection> localVarReturnType = new GenericType<UserConnection>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Sends an invitation to connect with another user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param connectionRequest  (required)
   * @return UserConnection
   * @throws ApiException if fails to make API call
   */
  public UserConnection v1ConnectionCreatePost(String sessionToken, UserConnectionRequest connectionRequest) throws ApiException {
    Object localVarPostBody = connectionRequest;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionCreatePost");
    }
    
    // verify the required parameter 'connectionRequest' is set
    if (connectionRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'connectionRequest' when calling v1ConnectionCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/connection/create";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserConnection> localVarReturnType = new GenericType<UserConnection>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * List of requesting user&#39;s connection
   * This retrieves all connections of the requesting user. (i.e. both connections in which the requesting user is the sender and those in which the requesting user is the inivtee) By default, if you haven&#39;t specified the connection status to filter on, this call will only return results for both \&quot;pending_incoming\&quot; and \&quot;pending_outgoing\&quot;. You can optionally filter by userIds to further restrict the results of a specific connection status. If the users are in the same private pod, the users have an implicit connection status of \&quot;accepted\&quot;. Those users will not be returned in the response if you don&#39;t specify the connection status as \&quot;accepted\&quot; (default is \&quot;pending\&quot;) and the explicit userIds in the request. 
   * @param sessionToken Session authentication token. (required)
   * @param status Filter the connection list based on the connection status. The connection status can only be pending_incoming, pending_outgoing, accepted, rejected, or all (all of the above)  (optional)
   * @param userIds The userIds parameter should be specified as a comma delimited list of user ids and can be used to restrict the results of a specific connection. Note that this is particularly important if the caller intends to retrieve results for implicit connection (user within the same pod). Implicit connections will not be included in the response if userId is not provided.  (optional)
   * @return UserConnectionList
   * @throws ApiException if fails to make API call
   */
  public UserConnectionList v1ConnectionListGet(String sessionToken, String status, String userIds) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/connection/list";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "status", status));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "userIds", userIds));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserConnectionList> localVarReturnType = new GenericType<UserConnectionList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Reject the connection request for the requesting user.
   * Reject the connection between the requesting user and request sender. If both users are in the same private pod, an error will be returned because both users have an implicit connection which cannot be rejected. 
   * @param sessionToken Session authentication token. (required)
   * @param connectionRequest  (required)
   * @return UserConnection
   * @throws ApiException if fails to make API call
   */
  public UserConnection v1ConnectionRejectPost(String sessionToken, UserConnectionRequest connectionRequest) throws ApiException {
    Object localVarPostBody = connectionRequest;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionRejectPost");
    }
    
    // verify the required parameter 'connectionRequest' is set
    if (connectionRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'connectionRequest' when calling v1ConnectionRejectPost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/connection/reject";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserConnection> localVarReturnType = new GenericType<UserConnection>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Removes a connection with a user.
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1ConnectionUserUidRemovePost(String sessionToken, Long uid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionUserUidRemovePost");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1ConnectionUserUidRemovePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/connection/user/{uid}/remove"
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * The status of the connection invitation to another user.
   * 
   * @param sessionToken Session authentication token. (required)
   * @param userId user Id (required)
   * @return UserConnection
   * @throws ApiException if fails to make API call
   */
  public UserConnection v1ConnectionUserUserIdInfoGet(String sessionToken, String userId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionUserUserIdInfoGet");
    }
    
    // verify the required parameter 'userId' is set
    if (userId == null) {
      throw new ApiException(400, "Missing the required parameter 'userId' when calling v1ConnectionUserUserIdInfoGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/connection/user/{userId}/info"
      .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserConnection> localVarReturnType = new GenericType<UserConnection>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
