package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.PodAppEntitlementList;
import org.symphonyoss.symphony.pod.model.UserAppEntitlementList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class AppEntitlementApi {
  private ApiClient apiClient;

  public AppEntitlementApi() {
    this(Configuration.getDefaultApiClient());
  }

  public AppEntitlementApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get the list of application entitlements for the company
   * 
   * @param sessionToken Session authentication token. (required)
   * @return PodAppEntitlementList
   * @throws ApiException if fails to make API call
   */
  public PodAppEntitlementList v1AdminAppEntitlementListGet(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminAppEntitlementListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/app/entitlement/list";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<PodAppEntitlementList> localVarReturnType = new GenericType<PodAppEntitlementList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update the application entitlements for the company
   * 
   * @param sessionToken Session authentication token. (required)
   * @param payload  (required)
   * @return PodAppEntitlementList
   * @throws ApiException if fails to make API call
   */
  public PodAppEntitlementList v1AdminAppEntitlementListPost(String sessionToken, PodAppEntitlementList payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminAppEntitlementListPost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminAppEntitlementListPost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/app/entitlement/list";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<PodAppEntitlementList> localVarReturnType = new GenericType<PodAppEntitlementList>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the list of application entitlements for this user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer (required)
   * @return UserAppEntitlementList
   * @throws ApiException if fails to make API call
   */
  public UserAppEntitlementList v1AdminUserUidAppEntitlementListGet(String sessionToken, Long uid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidAppEntitlementListGet");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidAppEntitlementListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/app/entitlement/list"
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserAppEntitlementList> localVarReturnType = new GenericType<UserAppEntitlementList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update the application entitlements for this user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer (required)
   * @param payload  (required)
   * @return UserAppEntitlementList
   * @throws ApiException if fails to make API call
   */
  public UserAppEntitlementList v1AdminUserUidAppEntitlementListPost(String sessionToken, Long uid, UserAppEntitlementList payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidAppEntitlementListPost");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidAppEntitlementListPost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminUserUidAppEntitlementListPost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/app/entitlement/list"
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserAppEntitlementList> localVarReturnType = new GenericType<UserAppEntitlementList>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
