/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.pod.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.pod.model.FacetedMatchCount;
import org.symphonyoss.symphony.pod.model.RoomSearchCriteria;
import org.symphonyoss.symphony.pod.model.V3RoomDetail;

@ApiModel(description="A list of search results and counts per search parameter.")
public class V3RoomSearchResults {
    @JsonProperty(value="count")
    private Long count = null;
    @JsonProperty(value="skip")
    private Integer skip = null;
    @JsonProperty(value="limit")
    private Integer limit = null;
    @JsonProperty(value="query")
    private RoomSearchCriteria query = null;
    @JsonProperty(value="rooms")
    private List<V3RoomDetail> rooms = null;
    @JsonProperty(value="facetedMatchCount")
    private List<FacetedMatchCount> facetedMatchCount = null;

    public V3RoomSearchResults count(Long count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(value="The total number of rooms matched by the search.")
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public V3RoomSearchResults skip(Integer skip) {
        this.skip = skip;
        return this;
    }

    @ApiModelProperty(value="The number of skipped results.")
    public Integer getSkip() {
        return this.skip;
    }

    public void setSkip(Integer skip) {
        this.skip = skip;
    }

    public V3RoomSearchResults limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(value="The number of returned results.")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public V3RoomSearchResults query(RoomSearchCriteria query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(value="The search query that produced this result.")
    public RoomSearchCriteria getQuery() {
        return this.query;
    }

    public void setQuery(RoomSearchCriteria query) {
        this.query = query;
    }

    public V3RoomSearchResults rooms(List<V3RoomDetail> rooms) {
        this.rooms = rooms;
        return this;
    }

    public V3RoomSearchResults addRoomsItem(V3RoomDetail roomsItem) {
        if (this.rooms == null) {
            this.rooms = new ArrayList<V3RoomDetail>();
        }
        this.rooms.add(roomsItem);
        return this;
    }

    @ApiModelProperty(value="A list of rooms matched by the query.")
    public List<V3RoomDetail> getRooms() {
        return this.rooms;
    }

    public void setRooms(List<V3RoomDetail> rooms) {
        this.rooms = rooms;
    }

    public V3RoomSearchResults facetedMatchCount(List<FacetedMatchCount> facetedMatchCount) {
        this.facetedMatchCount = facetedMatchCount;
        return this;
    }

    public V3RoomSearchResults addFacetedMatchCountItem(FacetedMatchCount facetedMatchCountItem) {
        if (this.facetedMatchCount == null) {
            this.facetedMatchCount = new ArrayList<FacetedMatchCount>();
        }
        this.facetedMatchCount.add(facetedMatchCountItem);
        return this;
    }

    @ApiModelProperty(value="Detailed counts of matched rooms per search criterion.")
    public List<FacetedMatchCount> getFacetedMatchCount() {
        return this.facetedMatchCount;
    }

    public void setFacetedMatchCount(List<FacetedMatchCount> facetedMatchCount) {
        this.facetedMatchCount = facetedMatchCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3RoomSearchResults v3RoomSearchResults = (V3RoomSearchResults)o;
        return Objects.equals(this.count, v3RoomSearchResults.count) && Objects.equals(this.skip, v3RoomSearchResults.skip) && Objects.equals(this.limit, v3RoomSearchResults.limit) && Objects.equals(this.query, v3RoomSearchResults.query) && Objects.equals(this.rooms, v3RoomSearchResults.rooms) && Objects.equals(this.facetedMatchCount, v3RoomSearchResults.facetedMatchCount);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.skip, this.limit, this.query, this.rooms, this.facetedMatchCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V3RoomSearchResults {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    skip: ").append(this.toIndentedString(this.skip)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    facetedMatchCount: ").append(this.toIndentedString(this.facetedMatchCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

