/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.pod.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.pod.model.ApplicationInfo;

@ApiModel(description="Detailed record of application.")
public class ApplicationDetail {
    @JsonProperty(value="applicationInfo")
    private ApplicationInfo applicationInfo = null;
    @JsonProperty(value="iconUrl")
    private String iconUrl = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="allowOrigins")
    private String allowOrigins = null;
    @JsonProperty(value="permissions")
    private List<String> permissions = null;
    @JsonProperty(value="cert")
    private String cert = null;

    public ApplicationDetail applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="Required info for the creation of an application.")
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public ApplicationDetail iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    @ApiModelProperty(value="Url to a icon to use for app. Must start with \"https://\".")
    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public ApplicationDetail description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the application.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApplicationDetail allowOrigins(String allowOrigins) {
        this.allowOrigins = allowOrigins;
        return this;
    }

    @ApiModelProperty(value="The permitted domains to send or receive a request from. The field is for the purpose of CORS which set the app specific \"ALLOW-ORIGIN-DOMAINS\" header in HTTP. ")
    public String getAllowOrigins() {
        return this.allowOrigins;
    }

    public void setAllowOrigins(String allowOrigins) {
        this.allowOrigins = allowOrigins;
    }

    public ApplicationDetail permissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public ApplicationDetail addPermissionsItem(String permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(value="List of application permissions provisioned for the application Accepted values:   - SEND_MESSAGES   - GET_USER_CONNECTIONS   - REQUEST_USER_CONNECTIONS   - SET_PRESENCE   - GET_PRESENCE   - GET_BASIC_USER_INFO   - GET_EXTENDED_USER_INFO   - GET_BASIC_CONTACT_INFO   - GET_EXTENDED_CONTACT_INFO   - ACT_AS_USER ")
    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public ApplicationDetail cert(String cert) {
        this.cert = cert;
        return this;
    }

    @ApiModelProperty(value="The app public certificate in pem format.")
    public String getCert() {
        return this.cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationDetail applicationDetail = (ApplicationDetail)o;
        return Objects.equals(this.applicationInfo, applicationDetail.applicationInfo) && Objects.equals(this.iconUrl, applicationDetail.iconUrl) && Objects.equals(this.description, applicationDetail.description) && Objects.equals(this.allowOrigins, applicationDetail.allowOrigins) && Objects.equals(this.permissions, applicationDetail.permissions) && Objects.equals(this.cert, applicationDetail.cert);
    }

    public int hashCode() {
        return Objects.hash(this.applicationInfo, this.iconUrl, this.description, this.allowOrigins, this.permissions, this.cert);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationDetail {\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    allowOrigins: ").append(this.toIndentedString(this.allowOrigins)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    cert: ").append(this.toIndentedString(this.cert)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

