/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.FacetedMatchCount;
import org.symphonyoss.symphony.pod.model.RoomSearchCriteria;
import org.symphonyoss.symphony.pod.model.V3RoomDetail;

/**
 * A list of search results and counts per search parameter.
 */
@ApiModel(description = "A list of search results and counts per search parameter.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class V3RoomSearchResults {
  @JsonProperty("count")
  private Long count = null;

  @JsonProperty("skip")
  private Integer skip = null;

  @JsonProperty("limit")
  private Integer limit = null;

  @JsonProperty("query")
  private RoomSearchCriteria query = null;

  @JsonProperty("rooms")
  private List<V3RoomDetail> rooms = null;

  @JsonProperty("facetedMatchCount")
  private List<FacetedMatchCount> facetedMatchCount = null;

  public V3RoomSearchResults count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * The total number of rooms matched by the search.
   * @return count
  **/
  @ApiModelProperty(value = "The total number of rooms matched by the search.")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public V3RoomSearchResults skip(Integer skip) {
    this.skip = skip;
    return this;
  }

   /**
   * The number of skipped results.
   * @return skip
  **/
  @ApiModelProperty(value = "The number of skipped results.")
  public Integer getSkip() {
    return skip;
  }

  public void setSkip(Integer skip) {
    this.skip = skip;
  }

  public V3RoomSearchResults limit(Integer limit) {
    this.limit = limit;
    return this;
  }

   /**
   * The number of returned results.
   * @return limit
  **/
  @ApiModelProperty(value = "The number of returned results.")
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public V3RoomSearchResults query(RoomSearchCriteria query) {
    this.query = query;
    return this;
  }

   /**
   * The search query that produced this result.
   * @return query
  **/
  @ApiModelProperty(value = "The search query that produced this result.")
  public RoomSearchCriteria getQuery() {
    return query;
  }

  public void setQuery(RoomSearchCriteria query) {
    this.query = query;
  }

  public V3RoomSearchResults rooms(List<V3RoomDetail> rooms) {
    this.rooms = rooms;
    return this;
  }

  public V3RoomSearchResults addRoomsItem(V3RoomDetail roomsItem) {
    if (this.rooms == null) {
      this.rooms = new ArrayList<V3RoomDetail>();
    }
    this.rooms.add(roomsItem);
    return this;
  }

   /**
   * A list of rooms matched by the query.
   * @return rooms
  **/
  @ApiModelProperty(value = "A list of rooms matched by the query.")
  public List<V3RoomDetail> getRooms() {
    return rooms;
  }

  public void setRooms(List<V3RoomDetail> rooms) {
    this.rooms = rooms;
  }

  public V3RoomSearchResults facetedMatchCount(List<FacetedMatchCount> facetedMatchCount) {
    this.facetedMatchCount = facetedMatchCount;
    return this;
  }

  public V3RoomSearchResults addFacetedMatchCountItem(FacetedMatchCount facetedMatchCountItem) {
    if (this.facetedMatchCount == null) {
      this.facetedMatchCount = new ArrayList<FacetedMatchCount>();
    }
    this.facetedMatchCount.add(facetedMatchCountItem);
    return this;
  }

   /**
   * Detailed counts of matched rooms per search criterion.
   * @return facetedMatchCount
  **/
  @ApiModelProperty(value = "Detailed counts of matched rooms per search criterion.")
  public List<FacetedMatchCount> getFacetedMatchCount() {
    return facetedMatchCount;
  }

  public void setFacetedMatchCount(List<FacetedMatchCount> facetedMatchCount) {
    this.facetedMatchCount = facetedMatchCount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V3RoomSearchResults v3RoomSearchResults = (V3RoomSearchResults) o;
    return Objects.equals(this.count, v3RoomSearchResults.count) &&
        Objects.equals(this.skip, v3RoomSearchResults.skip) &&
        Objects.equals(this.limit, v3RoomSearchResults.limit) &&
        Objects.equals(this.query, v3RoomSearchResults.query) &&
        Objects.equals(this.rooms, v3RoomSearchResults.rooms) &&
        Objects.equals(this.facetedMatchCount, v3RoomSearchResults.facetedMatchCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, skip, limit, query, rooms, facetedMatchCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V3RoomSearchResults {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    skip: ").append(toIndentedString(skip)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    facetedMatchCount: ").append(toIndentedString(facetedMatchCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

