/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.V2PresenceStatus;

/**
 * V2UserPresence
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class V2UserPresence {
  @JsonProperty("category")
  private String category = null;

  @JsonProperty("userId")
  private Long userId = null;

  public V2UserPresence category(String category) {
    this.category = category;
    return this;
  }

   /**
   * Presence status. Possible values are:   - UNDEFINED   - AVAILABLE   - BUSY   - DO_NOT_DISTURB   - ON_THE_PHONE   - BE_RIGHT_BACK   - IN_A_MEETING   - AWAY   - OUT_OF_OFFICE   - OFF_WORK   - OFFLINE 
   * @return category
  **/
  @ApiModelProperty(required = true, value = "Presence status. Possible values are:   - UNDEFINED   - AVAILABLE   - BUSY   - DO_NOT_DISTURB   - ON_THE_PHONE   - BE_RIGHT_BACK   - IN_A_MEETING   - AWAY   - OUT_OF_OFFICE   - OFF_WORK   - OFFLINE ")
  public String getCategory() {
    return category;
  }

  public void setCategory(String category) {
    this.category = category;
  }

  public V2UserPresence userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * The ID of the user to whom the presence state relates.
   * @return userId
  **/
  @ApiModelProperty(value = "The ID of the user to whom the presence state relates.")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2UserPresence v2UserPresence = (V2UserPresence) o;
    return Objects.equals(this.category, v2UserPresence.category) &&
        Objects.equals(this.userId, v2UserPresence.userId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(category, userId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2UserPresence {\n");
    
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

