/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * User detail information for stream membership
 */
@ApiModel(description = "User detail information for stream membership")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class V2MemberUserDetail {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("firstName")
  private String firstName = null;

  @JsonProperty("lastName")
  private String lastName = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("company")
  private String company = null;

  @JsonProperty("companyId")
  private Integer companyId = null;

  @JsonProperty("isExternal")
  private Boolean isExternal = null;

  public V2MemberUserDetail userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * Get userId
   * @return userId
  **/
  @ApiModelProperty(value = "")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  public V2MemberUserDetail email(String email) {
    this.email = email;
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @ApiModelProperty(value = "")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public V2MemberUserDetail firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

   /**
   * Get firstName
   * @return firstName
  **/
  @ApiModelProperty(value = "")
  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public V2MemberUserDetail lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

   /**
   * Get lastName
   * @return lastName
  **/
  @ApiModelProperty(value = "")
  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public V2MemberUserDetail displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Display name for the user
   * @return displayName
  **/
  @ApiModelProperty(value = "Display name for the user")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public V2MemberUserDetail company(String company) {
    this.company = company;
    return this;
  }

   /**
   * Company name
   * @return company
  **/
  @ApiModelProperty(value = "Company name")
  public String getCompany() {
    return company;
  }

  public void setCompany(String company) {
    this.company = company;
  }

  public V2MemberUserDetail companyId(Integer companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * Company ID
   * @return companyId
  **/
  @ApiModelProperty(value = "Company ID")
  public Integer getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Integer companyId) {
    this.companyId = companyId;
  }

  public V2MemberUserDetail isExternal(Boolean isExternal) {
    this.isExternal = isExternal;
    return this;
  }

   /**
   * true indicate that this user belong to another company
   * @return isExternal
  **/
  @ApiModelProperty(value = "true indicate that this user belong to another company")
  public Boolean getIsExternal() {
    return isExternal;
  }

  public void setIsExternal(Boolean isExternal) {
    this.isExternal = isExternal;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2MemberUserDetail v2MemberUserDetail = (V2MemberUserDetail) o;
    return Objects.equals(this.userId, v2MemberUserDetail.userId) &&
        Objects.equals(this.email, v2MemberUserDetail.email) &&
        Objects.equals(this.firstName, v2MemberUserDetail.firstName) &&
        Objects.equals(this.lastName, v2MemberUserDetail.lastName) &&
        Objects.equals(this.displayName, v2MemberUserDetail.displayName) &&
        Objects.equals(this.company, v2MemberUserDetail.company) &&
        Objects.equals(this.companyId, v2MemberUserDetail.companyId) &&
        Objects.equals(this.isExternal, v2MemberUserDetail.isExternal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, email, firstName, lastName, displayName, company, companyId, isExternal);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2MemberUserDetail {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    isExternal: ").append(toIndentedString(isExternal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

