/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.V2MemberUserDetail;

/**
 * Detailed membership record.
 */
@ApiModel(description = "Detailed membership record.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class V2MemberInfo {
  @JsonProperty("user")
  private V2MemberUserDetail user = null;

  @JsonProperty("isOwner")
  private Boolean isOwner = null;

  @JsonProperty("isCreator")
  private Boolean isCreator = null;

  @JsonProperty("joinDate")
  private Long joinDate = null;

  public V2MemberInfo user(V2MemberUserDetail user) {
    this.user = user;
    return this;
  }

   /**
   * User detail information include names, userId, email, etc
   * @return user
  **/
  @ApiModelProperty(value = "User detail information include names, userId, email, etc")
  public V2MemberUserDetail getUser() {
    return user;
  }

  public void setUser(V2MemberUserDetail user) {
    this.user = user;
  }

  public V2MemberInfo isOwner(Boolean isOwner) {
    this.isOwner = isOwner;
    return this;
  }

   /**
   * true if this is an owner of the room
   * @return isOwner
  **/
  @ApiModelProperty(value = "true if this is an owner of the room")
  public Boolean getIsOwner() {
    return isOwner;
  }

  public void setIsOwner(Boolean isOwner) {
    this.isOwner = isOwner;
  }

  public V2MemberInfo isCreator(Boolean isCreator) {
    this.isCreator = isCreator;
    return this;
  }

   /**
   * true if this is the creator of the room
   * @return isCreator
  **/
  @ApiModelProperty(value = "true if this is the creator of the room")
  public Boolean getIsCreator() {
    return isCreator;
  }

  public void setIsCreator(Boolean isCreator) {
    this.isCreator = isCreator;
  }

  public V2MemberInfo joinDate(Long joinDate) {
    this.joinDate = joinDate;
    return this;
  }

   /**
   * unix timestamp for join date
   * @return joinDate
  **/
  @ApiModelProperty(value = "unix timestamp for join date")
  public Long getJoinDate() {
    return joinDate;
  }

  public void setJoinDate(Long joinDate) {
    this.joinDate = joinDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2MemberInfo v2MemberInfo = (V2MemberInfo) o;
    return Objects.equals(this.user, v2MemberInfo.user) &&
        Objects.equals(this.isOwner, v2MemberInfo.isOwner) &&
        Objects.equals(this.isCreator, v2MemberInfo.isCreator) &&
        Objects.equals(this.joinDate, v2MemberInfo.joinDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(user, isOwner, isCreator, joinDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2MemberInfo {\n");
    
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    isOwner: ").append(toIndentedString(isOwner)).append("\n");
    sb.append("    isCreator: ").append(toIndentedString(isCreator)).append("\n");
    sb.append("    joinDate: ").append(toIndentedString(joinDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

