/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.UserSearchQuery;
import org.symphonyoss.symphony.pod.model.UserV2;

/**
 * UserSearchResults
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class UserSearchResults {
  @JsonProperty("count")
  private Long count = null;

  @JsonProperty("skip")
  private Long skip = null;

  @JsonProperty("limit")
  private Long limit = null;

  @JsonProperty("searchQuery")
  private UserSearchQuery searchQuery = null;

  @JsonProperty("users")
  private List<UserV2> users = null;

  public UserSearchResults count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * The total number of users which matched the search criteria.
   * @return count
  **/
  @ApiModelProperty(value = "The total number of users which matched the search criteria.")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public UserSearchResults skip(Long skip) {
    this.skip = skip;
    return this;
  }

   /**
   * The number of skipped results.
   * @return skip
  **/
  @ApiModelProperty(value = "The number of skipped results.")
  public Long getSkip() {
    return skip;
  }

  public void setSkip(Long skip) {
    this.skip = skip;
  }

  public UserSearchResults limit(Long limit) {
    this.limit = limit;
    return this;
  }

   /**
   * The number of returned results.
   * @return limit
  **/
  @ApiModelProperty(value = "The number of returned results.")
  public Long getLimit() {
    return limit;
  }

  public void setLimit(Long limit) {
    this.limit = limit;
  }

  public UserSearchResults searchQuery(UserSearchQuery searchQuery) {
    this.searchQuery = searchQuery;
    return this;
  }

   /**
   * The search query that produced this result.
   * @return searchQuery
  **/
  @ApiModelProperty(value = "The search query that produced this result.")
  public UserSearchQuery getSearchQuery() {
    return searchQuery;
  }

  public void setSearchQuery(UserSearchQuery searchQuery) {
    this.searchQuery = searchQuery;
  }

  public UserSearchResults users(List<UserV2> users) {
    this.users = users;
    return this;
  }

  public UserSearchResults addUsersItem(UserV2 usersItem) {
    if (this.users == null) {
      this.users = new ArrayList<UserV2>();
    }
    this.users.add(usersItem);
    return this;
  }

   /**
   * A list of users which matched by the search criteria.
   * @return users
  **/
  @ApiModelProperty(value = "A list of users which matched by the search criteria.")
  public List<UserV2> getUsers() {
    return users;
  }

  public void setUsers(List<UserV2> users) {
    this.users = users;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserSearchResults userSearchResults = (UserSearchResults) o;
    return Objects.equals(this.count, userSearchResults.count) &&
        Objects.equals(this.skip, userSearchResults.skip) &&
        Objects.equals(this.limit, userSearchResults.limit) &&
        Objects.equals(this.searchQuery, userSearchResults.searchQuery) &&
        Objects.equals(this.users, userSearchResults.users);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, skip, limit, searchQuery, users);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserSearchResults {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    skip: ").append(toIndentedString(skip)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    searchQuery: ").append(toIndentedString(searchQuery)).append("\n");
    sb.append("    users: ").append(toIndentedString(users)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

