/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Password. Stored as derived password in both the Pod and the Key Manager using PBKDF2 function. Number of iterations should be 10000 and desired length 256 bits.
 */
@ApiModel(description = "Password. Stored as derived password in both the Pod and the Key Manager using PBKDF2 function. Number of iterations should be 10000 and desired length 256 bits.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class Password {
  @JsonProperty("hSalt")
  private String hSalt = null;

  @JsonProperty("hPassword")
  private String hPassword = null;

  @JsonProperty("khSalt")
  private String khSalt = null;

  @JsonProperty("khPassword")
  private String khPassword = null;

  public Password hSalt(String hSalt) {
    this.hSalt = hSalt;
    return this;
  }

   /**
   * Pod password salt used for PBKDF2 derivation.
   * @return hSalt
  **/
  @ApiModelProperty(value = "Pod password salt used for PBKDF2 derivation.")
  public String getHSalt() {
    return hSalt;
  }

  public void setHSalt(String hSalt) {
    this.hSalt = hSalt;
  }

  public Password hPassword(String hPassword) {
    this.hPassword = hPassword;
    return this;
  }

   /**
   * Pod password derived with PBKDF2.
   * @return hPassword
  **/
  @ApiModelProperty(value = "Pod password derived with PBKDF2.")
  public String getHPassword() {
    return hPassword;
  }

  public void setHPassword(String hPassword) {
    this.hPassword = hPassword;
  }

  public Password khSalt(String khSalt) {
    this.khSalt = khSalt;
    return this;
  }

   /**
   * Key Manager password salt used for PBKDF2 derivation.
   * @return khSalt
  **/
  @ApiModelProperty(value = "Key Manager password salt used for PBKDF2 derivation.")
  public String getKhSalt() {
    return khSalt;
  }

  public void setKhSalt(String khSalt) {
    this.khSalt = khSalt;
  }

  public Password khPassword(String khPassword) {
    this.khPassword = khPassword;
    return this;
  }

   /**
   * Key Manager password derived with PBKDF2.
   * @return khPassword
  **/
  @ApiModelProperty(value = "Key Manager password derived with PBKDF2.")
  public String getKhPassword() {
    return khPassword;
  }

  public void setKhPassword(String khPassword) {
    this.khPassword = khPassword;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Password password = (Password) o;
    return Objects.equals(this.hSalt, password.hSalt) &&
        Objects.equals(this.hPassword, password.hPassword) &&
        Objects.equals(this.khSalt, password.khSalt) &&
        Objects.equals(this.khPassword, password.khPassword);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hSalt, hPassword, khSalt, khPassword);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Password {\n");
    
    sb.append("    hSalt: ").append(toIndentedString(hSalt)).append("\n");
    sb.append("    hPassword: ").append(toIndentedString(hPassword)).append("\n");
    sb.append("    khSalt: ").append(toIndentedString(khSalt)).append("\n");
    sb.append("    khPassword: ").append(toIndentedString(khPassword)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

