/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * CompanyCertInfo
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class CompanyCertInfo {
  @JsonProperty("fingerPrint")
  private String fingerPrint = null;

  @JsonProperty("issuerFingerPrint")
  private String issuerFingerPrint = null;

  @JsonProperty("lastSeen")
  private Long lastSeen = null;

  @JsonProperty("updatedAt")
  private Long updatedAt = null;

  @JsonProperty("updatedBy")
  private Long updatedBy = null;

  @JsonProperty("commonName")
  private String commonName = null;

  @JsonProperty("expiryDate")
  private Long expiryDate = null;

  public CompanyCertInfo fingerPrint(String fingerPrint) {
    this.fingerPrint = fingerPrint;
    return this;
  }

   /**
   * Unique identifier
   * @return fingerPrint
  **/
  @ApiModelProperty(value = "Unique identifier")
  public String getFingerPrint() {
    return fingerPrint;
  }

  public void setFingerPrint(String fingerPrint) {
    this.fingerPrint = fingerPrint;
  }

  public CompanyCertInfo issuerFingerPrint(String issuerFingerPrint) {
    this.issuerFingerPrint = issuerFingerPrint;
    return this;
  }

   /**
   * Unique identifier of issuer cert if known
   * @return issuerFingerPrint
  **/
  @ApiModelProperty(value = "Unique identifier of issuer cert if known")
  public String getIssuerFingerPrint() {
    return issuerFingerPrint;
  }

  public void setIssuerFingerPrint(String issuerFingerPrint) {
    this.issuerFingerPrint = issuerFingerPrint;
  }

  public CompanyCertInfo lastSeen(Long lastSeen) {
    this.lastSeen = lastSeen;
    return this;
  }

   /**
   * Date when we last saw this certificate presented
   * @return lastSeen
  **/
  @ApiModelProperty(value = "Date when we last saw this certificate presented")
  public Long getLastSeen() {
    return lastSeen;
  }

  public void setLastSeen(Long lastSeen) {
    this.lastSeen = lastSeen;
  }

  public CompanyCertInfo updatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Date when this cert was last updated by administrator
   * @return updatedAt
  **/
  @ApiModelProperty(value = "Date when this cert was last updated by administrator")
  public Long getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }

  public CompanyCertInfo updatedBy(Long updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * User ID of administrator who last updated this cert
   * @return updatedBy
  **/
  @ApiModelProperty(value = "User ID of administrator who last updated this cert")
  public Long getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(Long updatedBy) {
    this.updatedBy = updatedBy;
  }

  public CompanyCertInfo commonName(String commonName) {
    this.commonName = commonName;
    return this;
  }

   /**
   * The Symphony account name which this certificate authenticates
   * @return commonName
  **/
  @ApiModelProperty(value = "The Symphony account name which this certificate authenticates")
  public String getCommonName() {
    return commonName;
  }

  public void setCommonName(String commonName) {
    this.commonName = commonName;
  }

  public CompanyCertInfo expiryDate(Long expiryDate) {
    this.expiryDate = expiryDate;
    return this;
  }

   /**
   * Expiry date of this cert
   * @return expiryDate
  **/
  @ApiModelProperty(value = "Expiry date of this cert")
  public Long getExpiryDate() {
    return expiryDate;
  }

  public void setExpiryDate(Long expiryDate) {
    this.expiryDate = expiryDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyCertInfo companyCertInfo = (CompanyCertInfo) o;
    return Objects.equals(this.fingerPrint, companyCertInfo.fingerPrint) &&
        Objects.equals(this.issuerFingerPrint, companyCertInfo.issuerFingerPrint) &&
        Objects.equals(this.lastSeen, companyCertInfo.lastSeen) &&
        Objects.equals(this.updatedAt, companyCertInfo.updatedAt) &&
        Objects.equals(this.updatedBy, companyCertInfo.updatedBy) &&
        Objects.equals(this.commonName, companyCertInfo.commonName) &&
        Objects.equals(this.expiryDate, companyCertInfo.expiryDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fingerPrint, issuerFingerPrint, lastSeen, updatedAt, updatedBy, commonName, expiryDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyCertInfo {\n");
    
    sb.append("    fingerPrint: ").append(toIndentedString(fingerPrint)).append("\n");
    sb.append("    issuerFingerPrint: ").append(toIndentedString(issuerFingerPrint)).append("\n");
    sb.append("    lastSeen: ").append(toIndentedString(lastSeen)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    commonName: ").append(toIndentedString(commonName)).append("\n");
    sb.append("    expiryDate: ").append(toIndentedString(expiryDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

