/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.CompanyCertAttributes;

/**
 * CompanyCert
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class CompanyCert {
  @JsonProperty("pem")
  private String pem = null;

  @JsonProperty("attributes")
  private CompanyCertAttributes attributes = null;

  public CompanyCert pem(String pem) {
    this.pem = pem;
    return this;
  }

   /**
   * An X509 certificate in PEM format
   * @return pem
  **/
  @ApiModelProperty(value = "An X509 certificate in PEM format")
  public String getPem() {
    return pem;
  }

  public void setPem(String pem) {
    this.pem = pem;
  }

  public CompanyCert attributes(CompanyCertAttributes attributes) {
    this.attributes = attributes;
    return this;
  }

   /**
   * Get attributes
   * @return attributes
  **/
  @ApiModelProperty(value = "")
  public CompanyCertAttributes getAttributes() {
    return attributes;
  }

  public void setAttributes(CompanyCertAttributes attributes) {
    this.attributes = attributes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyCert companyCert = (CompanyCert) o;
    return Objects.equals(this.pem, companyCert.pem) &&
        Objects.equals(this.attributes, companyCert.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pem, attributes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyCert {\n");
    
    sb.append("    pem: ").append(toIndentedString(pem)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

