/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Required information for creating an application. 
 */
@ApiModel(description = "Required information for creating an application. ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class ApplicationInfo {
  @JsonProperty("appId")
  private String appId = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("appUrl")
  private String appUrl = null;

  @JsonProperty("domain")
  private String domain = null;

  @JsonProperty("publisher")
  private String publisher = null;

  public ApplicationInfo appId(String appId) {
    this.appId = appId;
    return this;
  }

   /**
   * An unique id for the application.
   * @return appId
  **/
  @ApiModelProperty(value = "An unique id for the application.")
  public String getAppId() {
    return appId;
  }

  public void setAppId(String appId) {
    this.appId = appId;
  }

  public ApplicationInfo name(String name) {
    this.name = name;
    return this;
  }

   /**
   * User defined name for the application.
   * @return name
  **/
  @ApiModelProperty(value = "User defined name for the application.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ApplicationInfo appUrl(String appUrl) {
    this.appUrl = appUrl;
    return this;
  }

   /**
   * The url for the app. Must start with \&quot;https://\&quot;.
   * @return appUrl
  **/
  @ApiModelProperty(value = "The url for the app. Must start with \"https://\".")
  public String getAppUrl() {
    return appUrl;
  }

  public void setAppUrl(String appUrl) {
    this.appUrl = appUrl;
  }

  public ApplicationInfo domain(String domain) {
    this.domain = domain;
    return this;
  }

   /**
   * Domain for app, that must match app url domain.
   * @return domain
  **/
  @ApiModelProperty(value = "Domain for app, that must match app url domain.")
  public String getDomain() {
    return domain;
  }

  public void setDomain(String domain) {
    this.domain = domain;
  }

  public ApplicationInfo publisher(String publisher) {
    this.publisher = publisher;
    return this;
  }

   /**
   * The publisher for this application.
   * @return publisher
  **/
  @ApiModelProperty(value = "The publisher for this application.")
  public String getPublisher() {
    return publisher;
  }

  public void setPublisher(String publisher) {
    this.publisher = publisher;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationInfo applicationInfo = (ApplicationInfo) o;
    return Objects.equals(this.appId, applicationInfo.appId) &&
        Objects.equals(this.name, applicationInfo.name) &&
        Objects.equals(this.appUrl, applicationInfo.appUrl) &&
        Objects.equals(this.domain, applicationInfo.domain) &&
        Objects.equals(this.publisher, applicationInfo.publisher);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, name, appUrl, domain, publisher);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationInfo {\n");
    
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    appUrl: ").append(toIndentedString(appUrl)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    publisher: ").append(toIndentedString(publisher)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

