/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.AdminStreamFilter;
import org.symphonyoss.symphony.pod.model.AdminStreamInfoList;

/**
 * list of streams info
 */
@ApiModel(description = "list of streams info")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class AdminStreamList {
  @JsonProperty("count")
  private Long count = null;

  @JsonProperty("skip")
  private Integer skip = null;

  @JsonProperty("limit")
  private Integer limit = null;

  @JsonProperty("filter")
  private AdminStreamFilter filter = null;

  @JsonProperty("streams")
  private AdminStreamInfoList streams = null;

  public AdminStreamList count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * total number of streams which match the filter criteria
   * @return count
  **/
  @ApiModelProperty(value = "total number of streams which match the filter criteria")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public AdminStreamList skip(Integer skip) {
    this.skip = skip;
    return this;
  }

   /**
   * number of streams skipped
   * @return skip
  **/
  @ApiModelProperty(value = "number of streams skipped")
  public Integer getSkip() {
    return skip;
  }

  public void setSkip(Integer skip) {
    this.skip = skip;
  }

  public AdminStreamList limit(Integer limit) {
    this.limit = limit;
    return this;
  }

   /**
   * maximum number of streams return
   * @return limit
  **/
  @ApiModelProperty(value = "maximum number of streams return")
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public AdminStreamList filter(AdminStreamFilter filter) {
    this.filter = filter;
    return this;
  }

   /**
   * filter criteria used in the request
   * @return filter
  **/
  @ApiModelProperty(value = "filter criteria used in the request")
  public AdminStreamFilter getFilter() {
    return filter;
  }

  public void setFilter(AdminStreamFilter filter) {
    this.filter = filter;
  }

  public AdminStreamList streams(AdminStreamInfoList streams) {
    this.streams = streams;
    return this;
  }

   /**
   * list of streams
   * @return streams
  **/
  @ApiModelProperty(value = "list of streams")
  public AdminStreamInfoList getStreams() {
    return streams;
  }

  public void setStreams(AdminStreamInfoList streams) {
    this.streams = streams;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdminStreamList adminStreamList = (AdminStreamList) o;
    return Objects.equals(this.count, adminStreamList.count) &&
        Objects.equals(this.skip, adminStreamList.skip) &&
        Objects.equals(this.limit, adminStreamList.limit) &&
        Objects.equals(this.filter, adminStreamList.filter) &&
        Objects.equals(this.streams, adminStreamList.streams);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, skip, limit, filter, streams);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdminStreamList {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    skip: ").append(toIndentedString(skip)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    streams: ").append(toIndentedString(streams)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

