/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.49.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.AdminStreamTypeEnum;

/**
 * stream filter criteria
 */
@ApiModel(description = "stream filter criteria")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class AdminStreamFilter {
  @JsonProperty("streamTypes")
  private List<AdminStreamTypeEnum> streamTypes = null;

  /**
   * scope of the room.  If not specified, it will include both Internal and External scope
   */
  public enum ScopeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    ScopeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ScopeEnum fromValue(String text) {
      for (ScopeEnum b : ScopeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("scope")
  private ScopeEnum scope = null;

  /**
   * Origin of the room. It indicate whether the room was created by a user within the company by another company.  If not specified, it will include both Internal and External origin 
   */
  public enum OriginEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    OriginEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OriginEnum fromValue(String text) {
      for (OriginEnum b : OriginEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("origin")
  private OriginEnum origin = null;

  /**
   * Status of the room. If not specified, it will include both Active and Inactive status
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  /**
   * Privacy setting of the stream.  If not specified, it will include both public and private stream
   */
  public enum PrivacyEnum {
    PUBLIC("PUBLIC"),
    
    PRIVATE("PRIVATE");

    private String value;

    PrivacyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PrivacyEnum fromValue(String text) {
      for (PrivacyEnum b : PrivacyEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("privacy")
  private PrivacyEnum privacy = null;

  @JsonProperty("startDate")
  private Long startDate = null;

  @JsonProperty("endDate")
  private Long endDate = null;

  public AdminStreamFilter streamTypes(List<AdminStreamTypeEnum> streamTypes) {
    this.streamTypes = streamTypes;
    return this;
  }

  public AdminStreamFilter addStreamTypesItem(AdminStreamTypeEnum streamTypesItem) {
    if (this.streamTypes == null) {
      this.streamTypes = new ArrayList<AdminStreamTypeEnum>();
    }
    this.streamTypes.add(streamTypesItem);
    return this;
  }

   /**
   * type of streams to search for
   * @return streamTypes
  **/
  @ApiModelProperty(value = "type of streams to search for")
  public List<AdminStreamTypeEnum> getStreamTypes() {
    return streamTypes;
  }

  public void setStreamTypes(List<AdminStreamTypeEnum> streamTypes) {
    this.streamTypes = streamTypes;
  }

  public AdminStreamFilter scope(ScopeEnum scope) {
    this.scope = scope;
    return this;
  }

   /**
   * scope of the room.  If not specified, it will include both Internal and External scope
   * @return scope
  **/
  @ApiModelProperty(value = "scope of the room.  If not specified, it will include both Internal and External scope")
  public ScopeEnum getScope() {
    return scope;
  }

  public void setScope(ScopeEnum scope) {
    this.scope = scope;
  }

  public AdminStreamFilter origin(OriginEnum origin) {
    this.origin = origin;
    return this;
  }

   /**
   * Origin of the room. It indicate whether the room was created by a user within the company by another company.  If not specified, it will include both Internal and External origin 
   * @return origin
  **/
  @ApiModelProperty(value = "Origin of the room. It indicate whether the room was created by a user within the company by another company.  If not specified, it will include both Internal and External origin ")
  public OriginEnum getOrigin() {
    return origin;
  }

  public void setOrigin(OriginEnum origin) {
    this.origin = origin;
  }

  public AdminStreamFilter status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Status of the room. If not specified, it will include both Active and Inactive status
   * @return status
  **/
  @ApiModelProperty(value = "Status of the room. If not specified, it will include both Active and Inactive status")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public AdminStreamFilter privacy(PrivacyEnum privacy) {
    this.privacy = privacy;
    return this;
  }

   /**
   * Privacy setting of the stream.  If not specified, it will include both public and private stream
   * @return privacy
  **/
  @ApiModelProperty(value = "Privacy setting of the stream.  If not specified, it will include both public and private stream")
  public PrivacyEnum getPrivacy() {
    return privacy;
  }

  public void setPrivacy(PrivacyEnum privacy) {
    this.privacy = privacy;
  }

  public AdminStreamFilter startDate(Long startDate) {
    this.startDate = startDate;
    return this;
  }

   /**
   * Start date in unix timestamp in millseconds
   * @return startDate
  **/
  @ApiModelProperty(value = "Start date in unix timestamp in millseconds")
  public Long getStartDate() {
    return startDate;
  }

  public void setStartDate(Long startDate) {
    this.startDate = startDate;
  }

  public AdminStreamFilter endDate(Long endDate) {
    this.endDate = endDate;
    return this;
  }

   /**
   * End date in unix timestamp in millseconds.  If not specified, it assume to be current time.
   * @return endDate
  **/
  @ApiModelProperty(value = "End date in unix timestamp in millseconds.  If not specified, it assume to be current time.")
  public Long getEndDate() {
    return endDate;
  }

  public void setEndDate(Long endDate) {
    this.endDate = endDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdminStreamFilter adminStreamFilter = (AdminStreamFilter) o;
    return Objects.equals(this.streamTypes, adminStreamFilter.streamTypes) &&
        Objects.equals(this.scope, adminStreamFilter.scope) &&
        Objects.equals(this.origin, adminStreamFilter.origin) &&
        Objects.equals(this.status, adminStreamFilter.status) &&
        Objects.equals(this.privacy, adminStreamFilter.privacy) &&
        Objects.equals(this.startDate, adminStreamFilter.startDate) &&
        Objects.equals(this.endDate, adminStreamFilter.endDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(streamTypes, scope, origin, status, privacy, startDate, endDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdminStreamFilter {\n");
    
    sb.append("    streamTypes: ").append(toIndentedString(streamTypes)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    privacy: ").append(toIndentedString(privacy)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

