package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.SessionInfo;
import org.symphonyoss.symphony.pod.model.UserV2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class SessionApi {
  private ApiClient apiClient;

  public SessionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public SessionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get information about the current user&#39;s session.
   * 
   * @param sessionToken Session authentication token. (required)
   * @return SessionInfo
   * @throws ApiException if fails to make API call
   */
  public SessionInfo v1SessioninfoGet(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1SessioninfoGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/sessioninfo";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SessionInfo> localVarReturnType = new GenericType<SessionInfo>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get information about the current user&#39;s session.
   * 
   * @param sessionToken Session authentication token. (required)
   * @return UserV2
   * @throws ApiException if fails to make API call
   */
  public UserV2 v2SessioninfoGet(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v2SessioninfoGet");
    }
    
    // create path and map variables
    String localVarPath = "/v2/sessioninfo";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserV2> localVarReturnType = new GenericType<UserV2>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
