package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.Presence;
import org.symphonyoss.symphony.pod.model.StringId;
import org.symphonyoss.symphony.pod.model.SuccessResponse;
import org.symphonyoss.symphony.pod.model.UserIdList;
import org.symphonyoss.symphony.pod.model.V2Presence;
import org.symphonyoss.symphony.pod.model.V2PresenceList;
import org.symphonyoss.symphony.pod.model.V2PresenceStatus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class PresenceApi {
  private ApiClient apiClient;

  public PresenceApi() {
    this(Configuration.getDefaultApiClient());
  }

  public PresenceApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create Presence status feed.
   * Create a new stream capturing presence status changes (\&quot;presence feed\&quot;). When read from, the feed will return the current presence status of company (pod) users if it has changed since the last read.  Returns the ID of the presence feed to be used in subsequent read operations. 
   * @param sessionToken Session authentication token. (required)
   * @return StringId
   * @throws ApiException if fails to make API call
   */
  public StringId v1PresenceFeedCreatePost(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1PresenceFeedCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/presence/feed/create";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<StringId> localVarReturnType = new GenericType<StringId>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete a presence status feed.
   * Returns the ID of the deleted feed. 
   * @param sessionToken Session authentication token. (required)
   * @param feedId Presence feed ID. (required)
   * @return StringId
   * @throws ApiException if fails to make API call
   */
  public StringId v1PresenceFeedFeedIdDeletePost(String sessionToken, String feedId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1PresenceFeedFeedIdDeletePost");
    }
    
    // verify the required parameter 'feedId' is set
    if (feedId == null) {
      throw new ApiException(400, "Missing the required parameter 'feedId' when calling v1PresenceFeedFeedIdDeletePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/presence/feed/{feedId}/delete"
      .replaceAll("\\{" + "feedId" + "\\}", apiClient.escapeString(feedId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<StringId> localVarReturnType = new GenericType<StringId>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Read a presence status feed.
   * Returns the current presence status of company (pod) users if it has changed since the last read. Returns up to 500 records at a time. 
   * @param sessionToken Session authentication token. (required)
   * @param feedId Presence feed ID. (required)
   * @return V2PresenceList
   * @throws ApiException if fails to make API call
   */
  public V2PresenceList v1PresenceFeedFeedIdReadGet(String sessionToken, String feedId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1PresenceFeedFeedIdReadGet");
    }
    
    // verify the required parameter 'feedId' is set
    if (feedId == null) {
      throw new ApiException(400, "Missing the required parameter 'feedId' when calling v1PresenceFeedFeedIdReadGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/presence/feed/{feedId}/read"
      .replaceAll("\\{" + "feedId" + "\\}", apiClient.escapeString(feedId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V2PresenceList> localVarReturnType = new GenericType<V2PresenceList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get presence information about the requesting user.
   * 
   * @param sessionToken Session authentication token. (required)
   * @return Presence
   * @throws ApiException if fails to make API call
   */
  public Presence v1UserPresenceGet(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1UserPresenceGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/user/presence";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Presence> localVarReturnType = new GenericType<Presence>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Set the presence of the requesting user.
   * 
   * @param sessionToken Session authentication token. (required)
   * @param presence  (required)
   * @return Presence
   * @throws ApiException if fails to make API call
   */
  public Presence v1UserPresencePost(String sessionToken, Presence presence) throws ApiException {
    Object localVarPostBody = presence;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1UserPresencePost");
    }
    
    // verify the required parameter 'presence' is set
    if (presence == null) {
      throw new ApiException(400, "Missing the required parameter 'presence' when calling v1UserPresencePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/user/presence";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Presence> localVarReturnType = new GenericType<Presence>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Register interest in a user&#39;s presence status
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uidList List of (integer) User IDs of users whose presence to query (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1UserPresenceRegisterPost(String sessionToken, UserIdList uidList) throws ApiException {
    Object localVarPostBody = uidList;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1UserPresenceRegisterPost");
    }
    
    // verify the required parameter 'uidList' is set
    if (uidList == null) {
      throw new ApiException(400, "Missing the required parameter 'uidList' when calling v1UserPresenceRegisterPost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/user/presence/register";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get presence information about a particular user.
   * 
   * @param uid User ID as a decimal integer  (required)
   * @param sessionToken Session authentication token. (required)
   * @return Presence
   * @throws ApiException if fails to make API call
   */
  public Presence v1UserUidPresenceGet(Long uid, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1UserUidPresenceGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1UserUidPresenceGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/user/{uid}/presence"
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Presence> localVarReturnType = new GenericType<Presence>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * LIMITED RELEASE Set presence information for a particular user.
   * Only the following states can be set AVAILABLE BUSY ON_THE_PHONE AWAY  Attempts to set other states will result in a 403 FORBIDDEN response.  The UNDEFINED value is an error case used to represent the case if the value stored in the system cannot be represented by the values known to the API.  The other states are reserved for future use. 
   * @param uid User ID as a decimal integer  (required)
   * @param sessionToken Session authentication token. (required)
   * @param presence  (required)
   * @return Presence
   * @throws ApiException if fails to make API call
   */
  public Presence v1UserUidPresencePost(Long uid, String sessionToken, Presence presence) throws ApiException {
    Object localVarPostBody = presence;
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1UserUidPresencePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1UserUidPresencePost");
    }
    
    // verify the required parameter 'presence' is set
    if (presence == null) {
      throw new ApiException(400, "Missing the required parameter 'presence' when calling v1UserUidPresencePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/user/{uid}/presence"
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Presence> localVarReturnType = new GenericType<Presence>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get presence information about the requesting user.
   * 
   * @param sessionToken Session authentication token. (required)
   * @return V2Presence
   * @throws ApiException if fails to make API call
   */
  public V2Presence v2UserPresenceGet(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v2UserPresenceGet");
    }
    
    // create path and map variables
    String localVarPath = "/v2/user/presence";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V2Presence> localVarReturnType = new GenericType<V2Presence>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Set the presence of the requesting user.
   * 
   * @param sessionToken Session authentication token. (required)
   * @param presence  (required)
   * @return V2Presence
   * @throws ApiException if fails to make API call
   */
  public V2Presence v2UserPresencePost(String sessionToken, V2PresenceStatus presence) throws ApiException {
    Object localVarPostBody = presence;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v2UserPresencePost");
    }
    
    // verify the required parameter 'presence' is set
    if (presence == null) {
      throw new ApiException(400, "Missing the required parameter 'presence' when calling v2UserPresencePost");
    }
    
    // create path and map variables
    String localVarPath = "/v2/user/presence";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V2Presence> localVarReturnType = new GenericType<V2Presence>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get presence information about a particular user.
   * 
   * @param uid User ID as a decimal integer  (required)
   * @param sessionToken Session authentication token. (required)
   * @param local If true, a local query will be performed and the presence will be set to OFFLINE for users who are not local to the calling user&#39;s pod. If false or absent, then the presence of all local users and the presence of all external users to whom the calling user is connected will be queried.  For external users, a \&quot;presence interest\&quot; should be registered through /v1/user/presence/register before querying for presence.  (optional, default to false)
   * @return Presence
   * @throws ApiException if fails to make API call
   */
  public Presence v2UserUidPresenceGet(Long uid, String sessionToken, Boolean local) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v2UserUidPresenceGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v2UserUidPresenceGet");
    }
    
    // create path and map variables
    String localVarPath = "/v2/user/{uid}/presence"
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "local", local));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Presence> localVarReturnType = new GenericType<Presence>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get presence information about a particular user.
   * 
   * @param uid User ID as a decimal integer  (required)
   * @param sessionToken Session authentication token. (required)
   * @param local If true, a local query will be performed and the presence will be set to OFFLINE for users who are not local to the calling user&#39;s pod. If false or absent, then the presence of all local users and the presence of all external users to whom the calling user is connected will be queried.  For external users, a \&quot;presence interest\&quot; should be registered through /v1/user/presence/register before querying for presence.  (optional, default to false)
   * @return V2Presence
   * @throws ApiException if fails to make API call
   */
  public V2Presence v3UserUidPresenceGet(Long uid, String sessionToken, Boolean local) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v3UserUidPresenceGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v3UserUidPresenceGet");
    }
    
    // create path and map variables
    String localVarPath = "/v3/user/{uid}/presence"
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "local", local));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V2Presence> localVarReturnType = new GenericType<V2Presence>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
