package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.MessageSuppressionResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class MessageSuppressionApi {
  private ApiClient apiClient;

  public MessageSuppressionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public MessageSuppressionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Suppress a message
   * 
   * @param id URL-Safe encoded Message ID (required)
   * @param sessionToken Session authentication token. (required)
   * @return MessageSuppressionResponse
   * @throws ApiException if fails to make API call
   */
  public MessageSuppressionResponse v1AdminMessagesuppressionIdSuppressPost(String id, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling v1AdminMessagesuppressionIdSuppressPost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminMessagesuppressionIdSuppressPost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/messagesuppression/{id}/suppress"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MessageSuppressionResponse> localVarReturnType = new GenericType<MessageSuppressionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
