package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.BulkActionResult;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.GroupList;
import org.symphonyoss.symphony.pod.model.IntegerList;
import org.symphonyoss.symphony.pod.model.PolicyList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-17T23:29:05.070-05:00")
public class InfoBarriersApi {
  private ApiClient apiClient;

  public InfoBarriersApi() {
    this(Configuration.getDefaultApiClient());
  }

  public InfoBarriersApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Add members to an Information Barrier group.
   * 
   * @param gid URL-Safe encoded Group ID (required)
   * @param sessionToken Session authentication token. (required)
   * @param users  (required)
   * @return BulkActionResult
   * @throws ApiException if fails to make API call
   */
  public BulkActionResult v1AdminGroupGidMembershipAddPost(String gid, String sessionToken, IntegerList users) throws ApiException {
    Object localVarPostBody = users;
    
    // verify the required parameter 'gid' is set
    if (gid == null) {
      throw new ApiException(400, "Missing the required parameter 'gid' when calling v1AdminGroupGidMembershipAddPost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminGroupGidMembershipAddPost");
    }
    
    // verify the required parameter 'users' is set
    if (users == null) {
      throw new ApiException(400, "Missing the required parameter 'users' when calling v1AdminGroupGidMembershipAddPost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/group/{gid}/membership/add"
      .replaceAll("\\{" + "gid" + "\\}", apiClient.escapeString(gid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<BulkActionResult> localVarReturnType = new GenericType<BulkActionResult>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the list of userids in this Information Barrier Group
   * 
   * @param gid URL-Safe encoded Group ID (required)
   * @param sessionToken Session authentication token. (required)
   * @return IntegerList
   * @throws ApiException if fails to make API call
   */
  public IntegerList v1AdminGroupGidMembershipListGet(String gid, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'gid' is set
    if (gid == null) {
      throw new ApiException(400, "Missing the required parameter 'gid' when calling v1AdminGroupGidMembershipListGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminGroupGidMembershipListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/group/{gid}/membership/list"
      .replaceAll("\\{" + "gid" + "\\}", apiClient.escapeString(gid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<IntegerList> localVarReturnType = new GenericType<IntegerList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Remove members from an Information Barrier group
   * 
   * @param gid URL-Safe encoded Group ID (required)
   * @param sessionToken Session authentication token. (required)
   * @param users  (required)
   * @return BulkActionResult
   * @throws ApiException if fails to make API call
   */
  public BulkActionResult v1AdminGroupGidMembershipRemovePost(String gid, String sessionToken, IntegerList users) throws ApiException {
    Object localVarPostBody = users;
    
    // verify the required parameter 'gid' is set
    if (gid == null) {
      throw new ApiException(400, "Missing the required parameter 'gid' when calling v1AdminGroupGidMembershipRemovePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminGroupGidMembershipRemovePost");
    }
    
    // verify the required parameter 'users' is set
    if (users == null) {
      throw new ApiException(400, "Missing the required parameter 'users' when calling v1AdminGroupGidMembershipRemovePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/group/{gid}/membership/remove"
      .replaceAll("\\{" + "gid" + "\\}", apiClient.escapeString(gid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<BulkActionResult> localVarReturnType = new GenericType<BulkActionResult>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of all Information Barrier Groups
   * 
   * @param sessionToken Session authentication token. (required)
   * @return GroupList
   * @throws ApiException if fails to make API call
   */
  public GroupList v1AdminGroupListGet(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminGroupListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/group/list";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<GroupList> localVarReturnType = new GenericType<GroupList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get all Information Policies
   * 
   * @param sessionToken Session authentication token. (required)
   * @return PolicyList
   * @throws ApiException if fails to make API call
   */
  public PolicyList v1AdminPolicyListGet(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminPolicyListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/policy/list";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<PolicyList> localVarReturnType = new GenericType<PolicyList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
