/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.pod.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Connection status between two users")
public class UserConnection {
    @JsonProperty(value="userId")
    private Long userId = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="firstRequestedAt")
    private Long firstRequestedAt = null;
    @JsonProperty(value="updatedAt")
    private Long updatedAt = null;
    @JsonProperty(value="requestCounter")
    private Integer requestCounter = null;

    public UserConnection userId(Long userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="user id")
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public UserConnection status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Connection status between the requesting user and the request sender")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public UserConnection firstRequestedAt(Long firstRequestedAt) {
        this.firstRequestedAt = firstRequestedAt;
        return this;
    }

    @ApiModelProperty(example="null", value="unix timestamp when the first request was made")
    public Long getFirstRequestedAt() {
        return this.firstRequestedAt;
    }

    public void setFirstRequestedAt(Long firstRequestedAt) {
        this.firstRequestedAt = firstRequestedAt;
    }

    public UserConnection updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(example="null", value="unix timestamp on the last updated date")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public UserConnection requestCounter(Integer requestCounter) {
        this.requestCounter = requestCounter;
        return this;
    }

    @ApiModelProperty(example="null", value="number of requests made")
    public Integer getRequestCounter() {
        return this.requestCounter;
    }

    public void setRequestCounter(Integer requestCounter) {
        this.requestCounter = requestCounter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserConnection userConnection = (UserConnection)o;
        return Objects.equals(this.userId, userConnection.userId) && Objects.equals((Object)this.status, (Object)userConnection.status) && Objects.equals(this.firstRequestedAt, userConnection.firstRequestedAt) && Objects.equals(this.updatedAt, userConnection.updatedAt) && Objects.equals(this.requestCounter, userConnection.requestCounter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userId, this.status, this.firstRequestedAt, this.updatedAt, this.requestCounter});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserConnection {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    firstRequestedAt: ").append(this.toIndentedString(this.firstRequestedAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    requestCounter: ").append(this.toIndentedString(this.requestCounter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING_INCOMING("pending_incoming"),
        PENDING_OUTGOING("pending_outgoing"),
        ACCEPTED("accepted"),
        REJECTED("rejected");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

