/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.40.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.model.UserConnectionRequest;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.UserConnection;
import org.symphonyoss.symphony.pod.model.UserConnectionList;
import org.junit.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API tests for ConnectionApi
 */
public class ConnectionApiTest {

    private final ConnectionApi api = new ConnectionApi();

    
    /**
     * Accept the connection request for the requesting user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ConnectionAcceptPostTest() throws ApiException {
        String sessionToken = null;
        UserConnectionRequest connectionRequest = null;
        // UserConnection response = api.v1ConnectionAcceptPost(sessionToken, connectionRequest);

        // TODO: test validations
    }
    
    /**
     * Sends an invitation to connect with another user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ConnectionCreatePostTest() throws ApiException {
        String sessionToken = null;
        UserConnectionRequest connectionRequest = null;
        // UserConnection response = api.v1ConnectionCreatePost(sessionToken, connectionRequest);

        // TODO: test validations
    }
    
    /**
     * List of requesting user&#39;s connection
     *
     * This retrieves all connections of the requesting user. (i.e. both connections in which the requesting user is the sender and those in which the requesting user is the inivtee) By default, if you haven&#39;t specified the connection status to filter on, this call will only return results for both \&quot;pending_incoming\&quot; and \&quot;pending_outgoing\&quot;. You can optionally filter by userIds to further restrict the results of a specific connection status. If the users are in the same private pod, the users have an implicit connection status of \&quot;accepted\&quot;. Those users will not be returned in the response if you don&#39;t specify the connection status as \&quot;accepted\&quot; (default is \&quot;pending\&quot;) and the explicit userIds in the request. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ConnectionListGetTest() throws ApiException {
        String sessionToken = null;
        String status = null;
        String userIds = null;
        // UserConnectionList response = api.v1ConnectionListGet(sessionToken, status, userIds);

        // TODO: test validations
    }
    
    /**
     * Reject the connection request for the requesting user.
     *
     * Reject the connection between the requesting user and request sender. If both users are in the same private pod, an error will be returned because both users have an implicit connection which cannot be rejected. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ConnectionRejectPostTest() throws ApiException {
        String sessionToken = null;
        UserConnectionRequest connectionRequest = null;
        // UserConnection response = api.v1ConnectionRejectPost(sessionToken, connectionRequest);

        // TODO: test validations
    }
    
    /**
     * The status of the connection invitation to another user.
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ConnectionUserUserIdInfoGetTest() throws ApiException {
        String sessionToken = null;
        String userId = null;
        // UserConnection response = api.v1ConnectionUserUserIdInfoGet(sessionToken, userId);

        // TODO: test validations
    }
    
}
