/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.40.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * Connection status between two users
 */
@ApiModel(description = "Connection status between two users")
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-10-02T23:49:31.153-04:00")
public class UserConnection   {
  @JsonProperty("userId")
  private Long userId = null;

  /**
   * Connection status between the requesting user and the request sender
   */
  public enum StatusEnum {
    PENDING_INCOMING("pending_incoming"),
    
    PENDING_OUTGOING("pending_outgoing"),
    
    ACCEPTED("accepted"),
    
    REJECTED("rejected");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
          if (String.valueOf(b.value).equals(text)) {
              return b;
          }
      }
      return null;
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("firstRequestedAt")
  private Long firstRequestedAt = null;

  @JsonProperty("updatedAt")
  private Long updatedAt = null;

  @JsonProperty("requestCounter")
  private Integer requestCounter = null;

  public UserConnection userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * user id
   * @return userId
  **/
  @ApiModelProperty(example = "null", value = "user id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  public UserConnection status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Connection status between the requesting user and the request sender
   * @return status
  **/
  @ApiModelProperty(example = "null", value = "Connection status between the requesting user and the request sender")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public UserConnection firstRequestedAt(Long firstRequestedAt) {
    this.firstRequestedAt = firstRequestedAt;
    return this;
  }

   /**
   * unix timestamp when the first request was made
   * @return firstRequestedAt
  **/
  @ApiModelProperty(example = "null", value = "unix timestamp when the first request was made")
  public Long getFirstRequestedAt() {
    return firstRequestedAt;
  }

  public void setFirstRequestedAt(Long firstRequestedAt) {
    this.firstRequestedAt = firstRequestedAt;
  }

  public UserConnection updatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * unix timestamp on the last updated date
   * @return updatedAt
  **/
  @ApiModelProperty(example = "null", value = "unix timestamp on the last updated date")
  public Long getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }

  public UserConnection requestCounter(Integer requestCounter) {
    this.requestCounter = requestCounter;
    return this;
  }

   /**
   * number of requests made
   * @return requestCounter
  **/
  @ApiModelProperty(example = "null", value = "number of requests made")
  public Integer getRequestCounter() {
    return requestCounter;
  }

  public void setRequestCounter(Integer requestCounter) {
    this.requestCounter = requestCounter;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserConnection userConnection = (UserConnection) o;
    return Objects.equals(this.userId, userConnection.userId) &&
        Objects.equals(this.status, userConnection.status) &&
        Objects.equals(this.firstRequestedAt, userConnection.firstRequestedAt) &&
        Objects.equals(this.updatedAt, userConnection.updatedAt) &&
        Objects.equals(this.requestCounter, userConnection.requestCounter);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, status, firstRequestedAt, updatedAt, requestCounter);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserConnection {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    firstRequestedAt: ").append(toIndentedString(firstRequestedAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    requestCounter: ").append(toIndentedString(requestCounter)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

