/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.40.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;


/**
 * User record.
 */
@ApiModel(description = "User record.")
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-10-02T23:49:31.153-04:00")
public class UserAttributes   {
  @JsonProperty("emailAddress")
  private String emailAddress = null;

  @JsonProperty("firstName")
  private String firstName = null;

  @JsonProperty("lastName")
  private String lastName = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("department")
  private String department = null;

  @JsonProperty("division")
  private String division = null;

  @JsonProperty("title")
  private String title = null;

  @JsonProperty("workPhoneNumber")
  private String workPhoneNumber = null;

  @JsonProperty("mobilePhoneNumber")
  private String mobilePhoneNumber = null;

  @JsonProperty("smsNumber")
  private String smsNumber = null;

  /**
   * Gets or Sets accountType
   */
  public enum AccountTypeEnum {
    NORMAL("NORMAL"),
    
    SYSTEM("SYSTEM");

    private String value;

    AccountTypeEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AccountTypeEnum fromValue(String text) {
      for (AccountTypeEnum b : AccountTypeEnum.values()) {
          if (String.valueOf(b.value).equals(text)) {
              return b;
          }
      }
      return null;
    }
  }

  @JsonProperty("accountType")
  private AccountTypeEnum accountType = null;

  @JsonProperty("location")
  private String location = null;

  @JsonProperty("jobFunction")
  private String jobFunction = null;

  @JsonProperty("assetClasses")
  private List<String> assetClasses = new ArrayList<String>();

  @JsonProperty("industries")
  private List<String> industries = new ArrayList<String>();

  public UserAttributes emailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

   /**
   * Get emailAddress
   * @return emailAddress
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getEmailAddress() {
    return emailAddress;
  }

  public void setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
  }

  public UserAttributes firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

   /**
   * Get firstName
   * @return firstName
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public UserAttributes lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

   /**
   * Get lastName
   * @return lastName
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public UserAttributes userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * Get userName
   * @return userName
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public UserAttributes displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public UserAttributes department(String department) {
    this.department = department;
    return this;
  }

   /**
   * Get department
   * @return department
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getDepartment() {
    return department;
  }

  public void setDepartment(String department) {
    this.department = department;
  }

  public UserAttributes division(String division) {
    this.division = division;
    return this;
  }

   /**
   * Get division
   * @return division
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getDivision() {
    return division;
  }

  public void setDivision(String division) {
    this.division = division;
  }

  public UserAttributes title(String title) {
    this.title = title;
    return this;
  }

   /**
   * Get title
   * @return title
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public UserAttributes workPhoneNumber(String workPhoneNumber) {
    this.workPhoneNumber = workPhoneNumber;
    return this;
  }

   /**
   * Get workPhoneNumber
   * @return workPhoneNumber
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getWorkPhoneNumber() {
    return workPhoneNumber;
  }

  public void setWorkPhoneNumber(String workPhoneNumber) {
    this.workPhoneNumber = workPhoneNumber;
  }

  public UserAttributes mobilePhoneNumber(String mobilePhoneNumber) {
    this.mobilePhoneNumber = mobilePhoneNumber;
    return this;
  }

   /**
   * Get mobilePhoneNumber
   * @return mobilePhoneNumber
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getMobilePhoneNumber() {
    return mobilePhoneNumber;
  }

  public void setMobilePhoneNumber(String mobilePhoneNumber) {
    this.mobilePhoneNumber = mobilePhoneNumber;
  }

  public UserAttributes smsNumber(String smsNumber) {
    this.smsNumber = smsNumber;
    return this;
  }

   /**
   * Get smsNumber
   * @return smsNumber
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getSmsNumber() {
    return smsNumber;
  }

  public void setSmsNumber(String smsNumber) {
    this.smsNumber = smsNumber;
  }

  public UserAttributes accountType(AccountTypeEnum accountType) {
    this.accountType = accountType;
    return this;
  }

   /**
   * Get accountType
   * @return accountType
  **/
  @ApiModelProperty(example = "null", value = "")
  public AccountTypeEnum getAccountType() {
    return accountType;
  }

  public void setAccountType(AccountTypeEnum accountType) {
    this.accountType = accountType;
  }

  public UserAttributes location(String location) {
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getLocation() {
    return location;
  }

  public void setLocation(String location) {
    this.location = location;
  }

  public UserAttributes jobFunction(String jobFunction) {
    this.jobFunction = jobFunction;
    return this;
  }

   /**
   * Get jobFunction
   * @return jobFunction
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getJobFunction() {
    return jobFunction;
  }

  public void setJobFunction(String jobFunction) {
    this.jobFunction = jobFunction;
  }

  public UserAttributes assetClasses(List<String> assetClasses) {
    this.assetClasses = assetClasses;
    return this;
  }

  public UserAttributes addAssetClassesItem(String assetClassesItem) {
    this.assetClasses.add(assetClassesItem);
    return this;
  }

   /**
   * Get assetClasses
   * @return assetClasses
  **/
  @ApiModelProperty(example = "null", value = "")
  public List<String> getAssetClasses() {
    return assetClasses;
  }

  public void setAssetClasses(List<String> assetClasses) {
    this.assetClasses = assetClasses;
  }

  public UserAttributes industries(List<String> industries) {
    this.industries = industries;
    return this;
  }

  public UserAttributes addIndustriesItem(String industriesItem) {
    this.industries.add(industriesItem);
    return this;
  }

   /**
   * Get industries
   * @return industries
  **/
  @ApiModelProperty(example = "null", value = "")
  public List<String> getIndustries() {
    return industries;
  }

  public void setIndustries(List<String> industries) {
    this.industries = industries;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserAttributes userAttributes = (UserAttributes) o;
    return Objects.equals(this.emailAddress, userAttributes.emailAddress) &&
        Objects.equals(this.firstName, userAttributes.firstName) &&
        Objects.equals(this.lastName, userAttributes.lastName) &&
        Objects.equals(this.userName, userAttributes.userName) &&
        Objects.equals(this.displayName, userAttributes.displayName) &&
        Objects.equals(this.department, userAttributes.department) &&
        Objects.equals(this.division, userAttributes.division) &&
        Objects.equals(this.title, userAttributes.title) &&
        Objects.equals(this.workPhoneNumber, userAttributes.workPhoneNumber) &&
        Objects.equals(this.mobilePhoneNumber, userAttributes.mobilePhoneNumber) &&
        Objects.equals(this.smsNumber, userAttributes.smsNumber) &&
        Objects.equals(this.accountType, userAttributes.accountType) &&
        Objects.equals(this.location, userAttributes.location) &&
        Objects.equals(this.jobFunction, userAttributes.jobFunction) &&
        Objects.equals(this.assetClasses, userAttributes.assetClasses) &&
        Objects.equals(this.industries, userAttributes.industries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(emailAddress, firstName, lastName, userName, displayName, department, division, title, workPhoneNumber, mobilePhoneNumber, smsNumber, accountType, location, jobFunction, assetClasses, industries);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserAttributes {\n");
    
    sb.append("    emailAddress: ").append(toIndentedString(emailAddress)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    department: ").append(toIndentedString(department)).append("\n");
    sb.append("    division: ").append(toIndentedString(division)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    workPhoneNumber: ").append(toIndentedString(workPhoneNumber)).append("\n");
    sb.append("    mobilePhoneNumber: ").append(toIndentedString(mobilePhoneNumber)).append("\n");
    sb.append("    smsNumber: ").append(toIndentedString(smsNumber)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    jobFunction: ").append(toIndentedString(jobFunction)).append("\n");
    sb.append("    assetClasses: ").append(toIndentedString(assetClasses)).append("\n");
    sb.append("    industries: ").append(toIndentedString(industries)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

