/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.40.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.FacetedMatchCount;
import org.symphonyoss.symphony.pod.model.RoomSearchCriteria;
import org.symphonyoss.symphony.pod.model.V2RoomDetail;


/**
 * A list of search results and counts per search parameter.
 */
@ApiModel(description = "A list of search results and counts per search parameter.")
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-10-02T23:49:31.153-04:00")
public class RoomSearchResults   {
  @JsonProperty("count")
  private Long count = null;

  @JsonProperty("skip")
  private Integer skip = null;

  @JsonProperty("limit")
  private Integer limit = null;

  @JsonProperty("query")
  private RoomSearchCriteria query = null;

  @JsonProperty("rooms")
  private List<V2RoomDetail> rooms = new ArrayList<V2RoomDetail>();

  @JsonProperty("facetedMatchCount")
  private List<FacetedMatchCount> facetedMatchCount = new ArrayList<FacetedMatchCount>();

  public RoomSearchResults count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * The total number of rooms matched by the search.
   * @return count
  **/
  @ApiModelProperty(example = "null", value = "The total number of rooms matched by the search.")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public RoomSearchResults skip(Integer skip) {
    this.skip = skip;
    return this;
  }

   /**
   * The number of skipped results.
   * @return skip
  **/
  @ApiModelProperty(example = "null", value = "The number of skipped results.")
  public Integer getSkip() {
    return skip;
  }

  public void setSkip(Integer skip) {
    this.skip = skip;
  }

  public RoomSearchResults limit(Integer limit) {
    this.limit = limit;
    return this;
  }

   /**
   * The number of returned results.
   * @return limit
  **/
  @ApiModelProperty(example = "null", value = "The number of returned results.")
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public RoomSearchResults query(RoomSearchCriteria query) {
    this.query = query;
    return this;
  }

   /**
   * The search query that produced this result.
   * @return query
  **/
  @ApiModelProperty(example = "null", value = "The search query that produced this result.")
  public RoomSearchCriteria getQuery() {
    return query;
  }

  public void setQuery(RoomSearchCriteria query) {
    this.query = query;
  }

  public RoomSearchResults rooms(List<V2RoomDetail> rooms) {
    this.rooms = rooms;
    return this;
  }

  public RoomSearchResults addRoomsItem(V2RoomDetail roomsItem) {
    this.rooms.add(roomsItem);
    return this;
  }

   /**
   * A list of rooms matched by the query.
   * @return rooms
  **/
  @ApiModelProperty(example = "null", value = "A list of rooms matched by the query.")
  public List<V2RoomDetail> getRooms() {
    return rooms;
  }

  public void setRooms(List<V2RoomDetail> rooms) {
    this.rooms = rooms;
  }

  public RoomSearchResults facetedMatchCount(List<FacetedMatchCount> facetedMatchCount) {
    this.facetedMatchCount = facetedMatchCount;
    return this;
  }

  public RoomSearchResults addFacetedMatchCountItem(FacetedMatchCount facetedMatchCountItem) {
    this.facetedMatchCount.add(facetedMatchCountItem);
    return this;
  }

   /**
   * Detailed counts of matched rooms per search criterion.
   * @return facetedMatchCount
  **/
  @ApiModelProperty(example = "null", value = "Detailed counts of matched rooms per search criterion.")
  public List<FacetedMatchCount> getFacetedMatchCount() {
    return facetedMatchCount;
  }

  public void setFacetedMatchCount(List<FacetedMatchCount> facetedMatchCount) {
    this.facetedMatchCount = facetedMatchCount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomSearchResults roomSearchResults = (RoomSearchResults) o;
    return Objects.equals(this.count, roomSearchResults.count) &&
        Objects.equals(this.skip, roomSearchResults.skip) &&
        Objects.equals(this.limit, roomSearchResults.limit) &&
        Objects.equals(this.query, roomSearchResults.query) &&
        Objects.equals(this.rooms, roomSearchResults.rooms) &&
        Objects.equals(this.facetedMatchCount, roomSearchResults.facetedMatchCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, skip, limit, query, rooms, facetedMatchCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomSearchResults {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    skip: ").append(toIndentedString(skip)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    facetedMatchCount: ").append(toIndentedString(facetedMatchCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

