/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.40.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * Application Product
 */
@ApiModel(description = "Application Product")
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-10-02T23:49:31.153-04:00")
public class Product   {
  @JsonProperty("appId")
  private String appId = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("sku")
  private String sku = null;

  @JsonProperty("subscribed")
  private Boolean subscribed = null;

  @JsonProperty("type")
  private String type = null;

  public Product appId(String appId) {
    this.appId = appId;
    return this;
  }

   /**
   * App ID for the Product
   * @return appId
  **/
  @ApiModelProperty(example = "null", value = "App ID for the Product")
  public String getAppId() {
    return appId;
  }

  public void setAppId(String appId) {
    this.appId = appId;
  }

  public Product name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Product Name
   * @return name
  **/
  @ApiModelProperty(example = "null", required = true, value = "Product Name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Product sku(String sku) {
    this.sku = sku;
    return this;
  }

   /**
   * Product SKU
   * @return sku
  **/
  @ApiModelProperty(example = "null", required = true, value = "Product SKU")
  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Product subscribed(Boolean subscribed) {
    this.subscribed = subscribed;
    return this;
  }

   /**
   * indicate whether the product is subscribed or not
   * @return subscribed
  **/
  @ApiModelProperty(example = "null", required = true, value = "indicate whether the product is subscribed or not")
  public Boolean getSubscribed() {
    return subscribed;
  }

  public void setSubscribed(Boolean subscribed) {
    this.subscribed = subscribed;
  }

  public Product type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Product Type (default or premium)
   * @return type
  **/
  @ApiModelProperty(example = "null", required = true, value = "Product Type (default or premium)")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Product product = (Product) o;
    return Objects.equals(this.appId, product.appId) &&
        Objects.equals(this.name, product.name) &&
        Objects.equals(this.sku, product.sku) &&
        Objects.equals(this.subscribed, product.subscribed) &&
        Objects.equals(this.type, product.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, name, sku, subscribed, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Product {\n");
    
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    sku: ").append(toIndentedString(sku)).append("\n");
    sb.append("    subscribed: ").append(toIndentedString(subscribed)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

