/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.40.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * Application Entitlements for the company
 */
@ApiModel(description = "Application Entitlements for the company")
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-10-02T23:49:31.153-04:00")
public class PodAppEntitlement   {
  @JsonProperty("appId")
  private String appId = null;

  @JsonProperty("appName")
  private String appName = null;

  @JsonProperty("enable")
  private Boolean enable = null;

  @JsonProperty("listed")
  private Boolean listed = null;

  @JsonProperty("install")
  private Boolean install = null;

  public PodAppEntitlement appId(String appId) {
    this.appId = appId;
    return this;
  }

   /**
   * Unique ID for the Application
   * @return appId
  **/
  @ApiModelProperty(example = "null", required = true, value = "Unique ID for the Application")
  public String getAppId() {
    return appId;
  }

  public void setAppId(String appId) {
    this.appId = appId;
  }

  public PodAppEntitlement appName(String appName) {
    this.appName = appName;
    return this;
  }

   /**
   * Name for this Application
   * @return appName
  **/
  @ApiModelProperty(example = "null", required = true, value = "Name for this Application")
  public String getAppName() {
    return appName;
  }

  public void setAppName(String appName) {
    this.appName = appName;
  }

  public PodAppEntitlement enable(Boolean enable) {
    this.enable = enable;
    return this;
  }

   /**
   * Get enable
   * @return enable
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public Boolean getEnable() {
    return enable;
  }

  public void setEnable(Boolean enable) {
    this.enable = enable;
  }

  public PodAppEntitlement listed(Boolean listed) {
    this.listed = listed;
    return this;
  }

   /**
   * if true, this application will be listed in the appstore for everyone.  Otherwise, this application will be hidden in the appstore.
   * @return listed
  **/
  @ApiModelProperty(example = "null", required = true, value = "if true, this application will be listed in the appstore for everyone.  Otherwise, this application will be hidden in the appstore.")
  public Boolean getListed() {
    return listed;
  }

  public void setListed(Boolean listed) {
    this.listed = listed;
  }

  public PodAppEntitlement install(Boolean install) {
    this.install = install;
    return this;
  }

   /**
   * if true, the entitlement is set to automatic for the company.  Otherwise, it is set to manual.
   * @return install
  **/
  @ApiModelProperty(example = "null", required = true, value = "if true, the entitlement is set to automatic for the company.  Otherwise, it is set to manual.")
  public Boolean getInstall() {
    return install;
  }

  public void setInstall(Boolean install) {
    this.install = install;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PodAppEntitlement podAppEntitlement = (PodAppEntitlement) o;
    return Objects.equals(this.appId, podAppEntitlement.appId) &&
        Objects.equals(this.appName, podAppEntitlement.appName) &&
        Objects.equals(this.enable, podAppEntitlement.enable) &&
        Objects.equals(this.listed, podAppEntitlement.listed) &&
        Objects.equals(this.install, podAppEntitlement.install);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, appName, enable, listed, install);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PodAppEntitlement {\n");
    
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    appName: ").append(toIndentedString(appName)).append("\n");
    sb.append("    enable: ").append(toIndentedString(enable)).append("\n");
    sb.append("    listed: ").append(toIndentedString(listed)).append("\n");
    sb.append("    install: ").append(toIndentedString(install)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

