package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.UserDetail;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.UserCreate;
import org.symphonyoss.symphony.pod.model.UserIdList;
import org.symphonyoss.symphony.pod.model.AvatarList;
import org.symphonyoss.symphony.pod.model.SuccessResponse;
import org.symphonyoss.symphony.pod.model.AvatarUpdate;
import org.symphonyoss.symphony.pod.model.IntegerList;
import org.symphonyoss.symphony.pod.model.DelegateAction;
import org.symphonyoss.symphony.pod.model.Disclaimer;
import org.symphonyoss.symphony.pod.model.StringId;
import org.symphonyoss.symphony.pod.model.FeatureList;
import org.symphonyoss.symphony.pod.model.UserStatus;
import org.symphonyoss.symphony.pod.model.UserAttributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-10-02T23:49:31.153-04:00")
public class UserApi {
  private ApiClient apiClient;

  public UserApi() {
    this(Configuration.getDefaultApiClient());
  }

  public UserApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create a new user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param payload  (required)
   * @return UserDetail
   * @throws ApiException if fails to make API call
   */
  public UserDetail v1AdminUserCreatePost(String sessionToken, UserCreate payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserCreatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminUserCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/create".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserDetail> localVarReturnType = new GenericType<UserDetail>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Retreive a list of all users in the company (pod)
   * 
   * @param sessionToken Session authentication token. (required)
   * @return UserIdList
   * @throws ApiException if fails to make API call
   */
  public UserIdList v1AdminUserListGet(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/list".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserIdList> localVarReturnType = new GenericType<UserIdList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the URL of the avatar of a particular user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @return AvatarList
   * @throws ApiException if fails to make API call
   */
  public AvatarList v1AdminUserUidAvatarGet(String sessionToken, Long uid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidAvatarGet");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidAvatarGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/avatar".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AvatarList> localVarReturnType = new GenericType<AvatarList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update the avatar of a particular user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @param payload  (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1AdminUserUidAvatarUpdatePost(String sessionToken, Long uid, AvatarUpdate payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidAvatarUpdatePost");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidAvatarUpdatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminUserUidAvatarUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/avatar/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the delegates assigned to a user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @return IntegerList
   * @throws ApiException if fails to make API call
   */
  public IntegerList v1AdminUserUidDelegatesGet(String sessionToken, Long uid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidDelegatesGet");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidDelegatesGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/delegates".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<IntegerList> localVarReturnType = new GenericType<IntegerList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update the delegates assigned to a user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @param payload  (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1AdminUserUidDelegatesUpdatePost(String sessionToken, Long uid, DelegateAction payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidDelegatesUpdatePost");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidDelegatesUpdatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminUserUidDelegatesUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/delegates/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the disclaimer assigned to a user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @return Disclaimer
   * @throws ApiException if fails to make API call
   */
  public Disclaimer v1AdminUserUidDisclaimerGet(String sessionToken, Long uid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidDisclaimerGet");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidDisclaimerGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/disclaimer".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Disclaimer> localVarReturnType = new GenericType<Disclaimer>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Assign a disclaimer to a user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @param payload  (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1AdminUserUidDisclaimerUpdatePost(String sessionToken, Long uid, StringId payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidDisclaimerUpdatePost");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidDisclaimerUpdatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminUserUidDisclaimerUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/disclaimer/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the list of Symphony feature entitlements enabled for a particular user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @return FeatureList
   * @throws ApiException if fails to make API call
   */
  public FeatureList v1AdminUserUidFeaturesGet(String sessionToken, Long uid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidFeaturesGet");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidFeaturesGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/features".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<FeatureList> localVarReturnType = new GenericType<FeatureList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update the list of Symphony feature entitlements for a particular user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @param payload  (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1AdminUserUidFeaturesUpdatePost(String sessionToken, Long uid, FeatureList payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidFeaturesUpdatePost");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidFeaturesUpdatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminUserUidFeaturesUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/features/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Retreive user details for a particular user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @return UserDetail
   * @throws ApiException if fails to make API call
   */
  public UserDetail v1AdminUserUidGet(String sessionToken, Long uid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidGet");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserDetail> localVarReturnType = new GenericType<UserDetail>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the status, active or inactive, for a particular user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @return UserStatus
   * @throws ApiException if fails to make API call
   */
  public UserStatus v1AdminUserUidStatusGet(String sessionToken, Long uid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidStatusGet");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidStatusGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/status".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserStatus> localVarReturnType = new GenericType<UserStatus>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update the status of a particular user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @param payload  (required)
   * @return SuccessResponse
   * @throws ApiException if fails to make API call
   */
  public SuccessResponse v1AdminUserUidStatusUpdatePost(String sessionToken, Long uid, UserStatus payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidStatusUpdatePost");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidStatusUpdatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminUserUidStatusUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/status/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update an existing user
   * 
   * @param sessionToken Session authentication token. (required)
   * @param uid User ID as a decimal integer  (required)
   * @param payload  (required)
   * @return UserDetail
   * @throws ApiException if fails to make API call
   */
  public UserDetail v1AdminUserUidUpdatePost(String sessionToken, Long uid, UserAttributes payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminUserUidUpdatePost");
    }
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AdminUserUidUpdatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminUserUidUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/user/{uid}/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserDetail> localVarReturnType = new GenericType<UserDetail>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
