package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.UserIdList;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.Stream;
import org.symphonyoss.symphony.pod.model.RoomCreate;
import org.symphonyoss.symphony.pod.model.RoomDetail;
import org.symphonyoss.symphony.pod.model.RoomAttributes;
import org.symphonyoss.symphony.pod.model.V2RoomAttributes;
import org.symphonyoss.symphony.pod.model.V2RoomDetail;
import org.symphonyoss.symphony.pod.model.RoomSearchCriteria;
import org.symphonyoss.symphony.pod.model.RoomSearchResults;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-10-02T23:49:31.153-04:00")
public class StreamsApi {
  private ApiClient apiClient;

  public StreamsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public StreamsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create a new single or multi party instant message conversation
   * At least two user IDs must be provided or an error response will be sent.  The caller is not included in the members of the created chat.  Duplicate users will be included in the membership of the chat but the duplication will be silently ignored.  If there is an existing IM conversation with the same set of participants then the id of that existing stream will be returned. 
   * @param uidList List of (integer) User IDs of participants (required)
   * @param sessionToken Session authentication token. (required)
   * @return Stream
   * @throws ApiException if fails to make API call
   */
  public Stream v1AdminImCreatePost(UserIdList uidList, String sessionToken) throws ApiException {
    Object localVarPostBody = uidList;
    
    // verify the required parameter 'uidList' is set
    if (uidList == null) {
      throw new ApiException(400, "Missing the required parameter 'uidList' when calling v1AdminImCreatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminImCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/im/create".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Stream> localVarReturnType = new GenericType<Stream>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Create a new single or multi party instant message conversation between the caller and specified users.
   * At least one user ID must be provided or an error response will be sent.  The caller is implicitly included in the members of the created chat.  Duplicate users will be included in the membership of the chat but the duplication will be silently ignored.  If there is an existing IM conversation with the same set of participants then the id of that existing stream will be returned.  This method was incorrectly specified to take a query parameter in version 1.0 of this specification but now expects a JSON array of user IDs in the body of the request. 
   * @param uidList List of (integer) User IDs of participants (required)
   * @param sessionToken Session authentication token. (required)
   * @return Stream
   * @throws ApiException if fails to make API call
   */
  public Stream v1ImCreatePost(UserIdList uidList, String sessionToken) throws ApiException {
    Object localVarPostBody = uidList;
    
    // verify the required parameter 'uidList' is set
    if (uidList == null) {
      throw new ApiException(400, "Missing the required parameter 'uidList' when calling v1ImCreatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ImCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/im/create".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Stream> localVarReturnType = new GenericType<Stream>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Create a new chatroom.
   * Create a new chatroom.  If no attributes are specified, the room is created as a private chatroom. 
   * @param payload  (required)
   * @param sessionToken Session authentication token. (required)
   * @return RoomDetail
   * @throws ApiException if fails to make API call
   */
  public RoomDetail v1RoomCreatePost(RoomCreate payload, String sessionToken) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1RoomCreatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1RoomCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/room/create".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<RoomDetail> localVarReturnType = new GenericType<RoomDetail>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get information about a partcular chatroom.
   * 
   * @param id Room streamId (required)
   * @param sessionToken Session authentication token. (required)
   * @return RoomDetail
   * @throws ApiException if fails to make API call
   */
  public RoomDetail v1RoomIdInfoGet(String id, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling v1RoomIdInfoGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1RoomIdInfoGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/room/{id}/info".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<RoomDetail> localVarReturnType = new GenericType<RoomDetail>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Deactivate or reactivate a chatroom. At creation, a new chatroom is active.
   * 
   * @param id Room streamId (required)
   * @param active  (required)
   * @param sessionToken Session authentication token. (required)
   * @return RoomDetail
   * @throws ApiException if fails to make API call
   */
  public RoomDetail v1RoomIdSetActivePost(String id, Boolean active, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling v1RoomIdSetActivePost");
    }
    
    // verify the required parameter 'active' is set
    if (active == null) {
      throw new ApiException(400, "Missing the required parameter 'active' when calling v1RoomIdSetActivePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1RoomIdSetActivePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/room/{id}/setActive".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "active", active));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<RoomDetail> localVarReturnType = new GenericType<RoomDetail>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update the attributes of an existing chatroom.
   * 
   * @param id Room streamId (required)
   * @param payload  (required)
   * @param sessionToken Session authentication token. (required)
   * @return RoomDetail
   * @throws ApiException if fails to make API call
   */
  public RoomDetail v1RoomIdUpdatePost(String id, RoomAttributes payload, String sessionToken) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling v1RoomIdUpdatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1RoomIdUpdatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1RoomIdUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/room/{id}/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<RoomDetail> localVarReturnType = new GenericType<RoomDetail>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Create a new chatroom.
   * Create a new chatroom.  If no  attributes are specified, the room is created as a private chatroom. 
   * @param payload  (required)
   * @param sessionToken Session authentication token. (required)
   * @return V2RoomDetail
   * @throws ApiException if fails to make API call
   */
  public V2RoomDetail v2RoomCreatePost(V2RoomAttributes payload, String sessionToken) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v2RoomCreatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v2RoomCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v2/room/create".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V2RoomDetail> localVarReturnType = new GenericType<V2RoomDetail>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get information about a partcular chatroom.
   * 
   * @param id Room streamId (required)
   * @param sessionToken Session authentication token. (required)
   * @return V2RoomDetail
   * @throws ApiException if fails to make API call
   */
  public V2RoomDetail v2RoomIdInfoGet(String id, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling v2RoomIdInfoGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v2RoomIdInfoGet");
    }
    
    // create path and map variables
    String localVarPath = "/v2/room/{id}/info".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V2RoomDetail> localVarReturnType = new GenericType<V2RoomDetail>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update the attributes of an existing chatroom.
   * 
   * @param id Room streamId (required)
   * @param payload  (required)
   * @param sessionToken Session authentication token. (required)
   * @return V2RoomDetail
   * @throws ApiException if fails to make API call
   */
  public V2RoomDetail v2RoomIdUpdatePost(String id, V2RoomAttributes payload, String sessionToken) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling v2RoomIdUpdatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v2RoomIdUpdatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v2RoomIdUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v2/room/{id}/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V2RoomDetail> localVarReturnType = new GenericType<V2RoomDetail>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Search rooms according to the specified criteria.
   * 
   * @param sessionToken Session authentication token. (required)
   * @param query The search query object. (required)
   * @param skip No. of results to skip.  (optional)
   * @param limit Max no. of results to return. If no value is provided, 50 is the default.  (optional)
   * @return RoomSearchResults
   * @throws ApiException if fails to make API call
   */
  public RoomSearchResults v2RoomSearchPost(String sessionToken, RoomSearchCriteria query, Integer skip, Integer limit) throws ApiException {
    Object localVarPostBody = query;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v2RoomSearchPost");
    }
    
    // verify the required parameter 'query' is set
    if (query == null) {
      throw new ApiException(400, "Missing the required parameter 'query' when calling v2RoomSearchPost");
    }
    
    // create path and map variables
    String localVarPath = "/v2/room/search".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "skip", skip));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<RoomSearchResults> localVarReturnType = new GenericType<RoomSearchResults>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
