# StreamsApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1AdminImCreatePost**](StreamsApi.md#v1AdminImCreatePost) | **POST** /v1/admin/im/create | Create a new single or multi party instant message conversation
[**v1ImCreatePost**](StreamsApi.md#v1ImCreatePost) | **POST** /v1/im/create | Create a new single or multi party instant message conversation between the caller and specified users.
[**v1RoomCreatePost**](StreamsApi.md#v1RoomCreatePost) | **POST** /v1/room/create | Create a new chatroom.
[**v1RoomIdInfoGet**](StreamsApi.md#v1RoomIdInfoGet) | **GET** /v1/room/{id}/info | Get information about a partcular chatroom.
[**v1RoomIdSetActivePost**](StreamsApi.md#v1RoomIdSetActivePost) | **POST** /v1/room/{id}/setActive | Deactivate or reactivate a chatroom. At creation, a new chatroom is active.
[**v1RoomIdUpdatePost**](StreamsApi.md#v1RoomIdUpdatePost) | **POST** /v1/room/{id}/update | Update the attributes of an existing chatroom.
[**v2RoomCreatePost**](StreamsApi.md#v2RoomCreatePost) | **POST** /v2/room/create | Create a new chatroom.
[**v2RoomIdInfoGet**](StreamsApi.md#v2RoomIdInfoGet) | **GET** /v2/room/{id}/info | Get information about a partcular chatroom.
[**v2RoomIdUpdatePost**](StreamsApi.md#v2RoomIdUpdatePost) | **POST** /v2/room/{id}/update | Update the attributes of an existing chatroom.
[**v2RoomSearchPost**](StreamsApi.md#v2RoomSearchPost) | **POST** /v2/room/search | Search rooms according to the specified criteria.


<a name="v1AdminImCreatePost"></a>
# **v1AdminImCreatePost**
> Stream v1AdminImCreatePost(uidList, sessionToken)

Create a new single or multi party instant message conversation

At least two user IDs must be provided or an error response will be sent.  The caller is not included in the members of the created chat.  Duplicate users will be included in the membership of the chat but the duplication will be silently ignored.  If there is an existing IM conversation with the same set of participants then the id of that existing stream will be returned. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
UserIdList uidList = new UserIdList(); // UserIdList | List of (integer) User IDs of participants
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    Stream result = apiInstance.v1AdminImCreatePost(uidList, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v1AdminImCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **uidList** | [**UserIdList**](UserIdList.md)| List of (integer) User IDs of participants |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**Stream**](Stream.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1ImCreatePost"></a>
# **v1ImCreatePost**
> Stream v1ImCreatePost(uidList, sessionToken)

Create a new single or multi party instant message conversation between the caller and specified users.

At least one user ID must be provided or an error response will be sent.  The caller is implicitly included in the members of the created chat.  Duplicate users will be included in the membership of the chat but the duplication will be silently ignored.  If there is an existing IM conversation with the same set of participants then the id of that existing stream will be returned.  This method was incorrectly specified to take a query parameter in version 1.0 of this specification but now expects a JSON array of user IDs in the body of the request. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
UserIdList uidList = new UserIdList(); // UserIdList | List of (integer) User IDs of participants
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    Stream result = apiInstance.v1ImCreatePost(uidList, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v1ImCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **uidList** | [**UserIdList**](UserIdList.md)| List of (integer) User IDs of participants |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**Stream**](Stream.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1RoomCreatePost"></a>
# **v1RoomCreatePost**
> RoomDetail v1RoomCreatePost(payload, sessionToken)

Create a new chatroom.

Create a new chatroom.  If no attributes are specified, the room is created as a private chatroom. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
RoomCreate payload = new RoomCreate(); // RoomCreate | 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    RoomDetail result = apiInstance.v1RoomCreatePost(payload, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v1RoomCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **payload** | [**RoomCreate**](RoomCreate.md)|  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**RoomDetail**](RoomDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1RoomIdInfoGet"></a>
# **v1RoomIdInfoGet**
> RoomDetail v1RoomIdInfoGet(id, sessionToken)

Get information about a partcular chatroom.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
String id = "id_example"; // String | Room streamId
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    RoomDetail result = apiInstance.v1RoomIdInfoGet(id, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v1RoomIdInfoGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**RoomDetail**](RoomDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1RoomIdSetActivePost"></a>
# **v1RoomIdSetActivePost**
> RoomDetail v1RoomIdSetActivePost(id, active, sessionToken)

Deactivate or reactivate a chatroom. At creation, a new chatroom is active.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
String id = "id_example"; // String | Room streamId
Boolean active = true; // Boolean | 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    RoomDetail result = apiInstance.v1RoomIdSetActivePost(id, active, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v1RoomIdSetActivePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **active** | **Boolean**|  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**RoomDetail**](RoomDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1RoomIdUpdatePost"></a>
# **v1RoomIdUpdatePost**
> RoomDetail v1RoomIdUpdatePost(id, payload, sessionToken)

Update the attributes of an existing chatroom.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
String id = "id_example"; // String | Room streamId
RoomAttributes payload = new RoomAttributes(); // RoomAttributes | 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    RoomDetail result = apiInstance.v1RoomIdUpdatePost(id, payload, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v1RoomIdUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **payload** | [**RoomAttributes**](RoomAttributes.md)|  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**RoomDetail**](RoomDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v2RoomCreatePost"></a>
# **v2RoomCreatePost**
> V2RoomDetail v2RoomCreatePost(payload, sessionToken)

Create a new chatroom.

Create a new chatroom.  If no  attributes are specified, the room is created as a private chatroom. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
V2RoomAttributes payload = new V2RoomAttributes(); // V2RoomAttributes | 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    V2RoomDetail result = apiInstance.v2RoomCreatePost(payload, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v2RoomCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **payload** | [**V2RoomAttributes**](V2RoomAttributes.md)|  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**V2RoomDetail**](V2RoomDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v2RoomIdInfoGet"></a>
# **v2RoomIdInfoGet**
> V2RoomDetail v2RoomIdInfoGet(id, sessionToken)

Get information about a partcular chatroom.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
String id = "id_example"; // String | Room streamId
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    V2RoomDetail result = apiInstance.v2RoomIdInfoGet(id, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v2RoomIdInfoGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**V2RoomDetail**](V2RoomDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v2RoomIdUpdatePost"></a>
# **v2RoomIdUpdatePost**
> V2RoomDetail v2RoomIdUpdatePost(id, payload, sessionToken)

Update the attributes of an existing chatroom.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
String id = "id_example"; // String | Room streamId
V2RoomAttributes payload = new V2RoomAttributes(); // V2RoomAttributes | 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    V2RoomDetail result = apiInstance.v2RoomIdUpdatePost(id, payload, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v2RoomIdUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **payload** | [**V2RoomAttributes**](V2RoomAttributes.md)|  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**V2RoomDetail**](V2RoomDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v2RoomSearchPost"></a>
# **v2RoomSearchPost**
> RoomSearchResults v2RoomSearchPost(sessionToken, query, skip, limit)

Search rooms according to the specified criteria.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.StreamsApi;


StreamsApi apiInstance = new StreamsApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
RoomSearchCriteria query = new RoomSearchCriteria(); // RoomSearchCriteria | The search query object.
Integer skip = 56; // Integer | No. of results to skip. 
Integer limit = 56; // Integer | Max no. of results to return. If no value is provided, 50 is the default. 
try {
    RoomSearchResults result = apiInstance.v2RoomSearchPost(sessionToken, query, skip, limit);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling StreamsApi#v2RoomSearchPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **query** | [**RoomSearchCriteria**](RoomSearchCriteria.md)| The search query object. |
 **skip** | **Integer**| No. of results to skip.  | [optional]
 **limit** | **Integer**| Max no. of results to return. If no value is provided, 50 is the default.  | [optional]

### Return type

[**RoomSearchResults**](RoomSearchResults.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

