# SecurityApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1CompanycertCreatePost**](SecurityApi.md#v1CompanycertCreatePost) | **POST** /v1/companycert/create | Create a company trusted or untrusted certificate
[**v1CompanycertDeletePost**](SecurityApi.md#v1CompanycertDeletePost) | **POST** /v1/companycert/delete | Delete a company certificate
[**v1CompanycertFingerPrintGetGet**](SecurityApi.md#v1CompanycertFingerPrintGetGet) | **GET** /v1/companycert/{fingerPrint}/get | Get the details of a company certificate
[**v1CompanycertFingerPrintIssuedByGet**](SecurityApi.md#v1CompanycertFingerPrintIssuedByGet) | **GET** /v1/companycert/{fingerPrint}/issuedBy | Return a list of all certificates which were verified to the cert whose fingerprint is passed. 
[**v1CompanycertFingerPrintUpdatePost**](SecurityApi.md#v1CompanycertFingerPrintUpdatePost) | **POST** /v1/companycert/{fingerPrint}/update | Update a company certificate
[**v1CompanycertListGet**](SecurityApi.md#v1CompanycertListGet) | **GET** /v1/companycert/list | List all trusted certs
[**v1CompanycertPodmanagedListGet**](SecurityApi.md#v1CompanycertPodmanagedListGet) | **GET** /v1/companycert/podmanaged/list | List all trusted certs
[**v1CompanycertTypeListPost**](SecurityApi.md#v1CompanycertTypeListPost) | **POST** /v1/companycert/type/list | List all certs of the given types


<a name="v1CompanycertCreatePost"></a>
# **v1CompanycertCreatePost**
> SuccessResponse v1CompanycertCreatePost(sessionToken, cert)

Create a company trusted or untrusted certificate

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.SecurityApi;


SecurityApi apiInstance = new SecurityApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
CompanyCert cert = new CompanyCert(); // CompanyCert | 
try {
    SuccessResponse result = apiInstance.v1CompanycertCreatePost(sessionToken, cert);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling SecurityApi#v1CompanycertCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **cert** | [**CompanyCert**](CompanyCert.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1CompanycertDeletePost"></a>
# **v1CompanycertDeletePost**
> SuccessResponse v1CompanycertDeletePost(sessionToken, fingerPrint)

Delete a company certificate

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.SecurityApi;


SecurityApi apiInstance = new SecurityApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
StringId fingerPrint = new StringId(); // StringId | 
try {
    SuccessResponse result = apiInstance.v1CompanycertDeletePost(sessionToken, fingerPrint);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling SecurityApi#v1CompanycertDeletePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **fingerPrint** | [**StringId**](StringId.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1CompanycertFingerPrintGetGet"></a>
# **v1CompanycertFingerPrintGetGet**
> CompanyCertDetail v1CompanycertFingerPrintGetGet(fingerPrint, sessionToken)

Get the details of a company certificate

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.SecurityApi;


SecurityApi apiInstance = new SecurityApi();
String fingerPrint = "fingerPrint_example"; // String | Certificate fingerPrint (ID)
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    CompanyCertDetail result = apiInstance.v1CompanycertFingerPrintGetGet(fingerPrint, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling SecurityApi#v1CompanycertFingerPrintGetGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **fingerPrint** | **String**| Certificate fingerPrint (ID) |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**CompanyCertDetail**](CompanyCertDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1CompanycertFingerPrintIssuedByGet"></a>
# **v1CompanycertFingerPrintIssuedByGet**
> CompanyCertInfoList v1CompanycertFingerPrintIssuedByGet(fingerPrint, sessionToken)

Return a list of all certificates which were verified to the cert whose fingerprint is passed. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.SecurityApi;


SecurityApi apiInstance = new SecurityApi();
String fingerPrint = "fingerPrint_example"; // String | Certificate fingerPrint (ID)
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    CompanyCertInfoList result = apiInstance.v1CompanycertFingerPrintIssuedByGet(fingerPrint, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling SecurityApi#v1CompanycertFingerPrintIssuedByGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **fingerPrint** | **String**| Certificate fingerPrint (ID) |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**CompanyCertInfoList**](CompanyCertInfoList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1CompanycertFingerPrintUpdatePost"></a>
# **v1CompanycertFingerPrintUpdatePost**
> SuccessResponse v1CompanycertFingerPrintUpdatePost(fingerPrint, sessionToken, certAttributes)

Update a company certificate

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.SecurityApi;


SecurityApi apiInstance = new SecurityApi();
String fingerPrint = "fingerPrint_example"; // String | Certificate fingerPrint (ID)
String sessionToken = "sessionToken_example"; // String | Session authentication token.
CompanyCertAttributes certAttributes = new CompanyCertAttributes(); // CompanyCertAttributes | 
try {
    SuccessResponse result = apiInstance.v1CompanycertFingerPrintUpdatePost(fingerPrint, sessionToken, certAttributes);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling SecurityApi#v1CompanycertFingerPrintUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **fingerPrint** | **String**| Certificate fingerPrint (ID) |
 **sessionToken** | **String**| Session authentication token. |
 **certAttributes** | [**CompanyCertAttributes**](CompanyCertAttributes.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1CompanycertListGet"></a>
# **v1CompanycertListGet**
> CompanyCertInfoList v1CompanycertListGet(sessionToken, skip, limit)

List all trusted certs

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.SecurityApi;


SecurityApi apiInstance = new SecurityApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Integer skip = 56; // Integer | Pagination start
Integer limit = 56; // Integer | Row limit
try {
    CompanyCertInfoList result = apiInstance.v1CompanycertListGet(sessionToken, skip, limit);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling SecurityApi#v1CompanycertListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **skip** | **Integer**| Pagination start | [optional]
 **limit** | **Integer**| Row limit | [optional]

### Return type

[**CompanyCertInfoList**](CompanyCertInfoList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1CompanycertPodmanagedListGet"></a>
# **v1CompanycertPodmanagedListGet**
> CompanyCertInfoList v1CompanycertPodmanagedListGet(sessionToken, skip, limit)

List all trusted certs

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.SecurityApi;


SecurityApi apiInstance = new SecurityApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Integer skip = 56; // Integer | Pagination start
Integer limit = 56; // Integer | Row limit
try {
    CompanyCertInfoList result = apiInstance.v1CompanycertPodmanagedListGet(sessionToken, skip, limit);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling SecurityApi#v1CompanycertPodmanagedListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **skip** | **Integer**| Pagination start | [optional]
 **limit** | **Integer**| Row limit | [optional]

### Return type

[**CompanyCertInfoList**](CompanyCertInfoList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1CompanycertTypeListPost"></a>
# **v1CompanycertTypeListPost**
> CompanyCertInfoList v1CompanycertTypeListPost(typeIdList, sessionToken, skip, limit)

List all certs of the given types

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.SecurityApi;


SecurityApi apiInstance = new SecurityApi();
CompanyCertTypeList typeIdList = new CompanyCertTypeList(); // CompanyCertTypeList | Certificate type list
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Integer skip = 56; // Integer | Pagination start
Integer limit = 56; // Integer | Row limit
try {
    CompanyCertInfoList result = apiInstance.v1CompanycertTypeListPost(typeIdList, sessionToken, skip, limit);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling SecurityApi#v1CompanycertTypeListPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **typeIdList** | [**CompanyCertTypeList**](CompanyCertTypeList.md)| Certificate type list |
 **sessionToken** | **String**| Session authentication token. |
 **skip** | **Integer**| Pagination start | [optional]
 **limit** | **Integer**| Row limit | [optional]

### Return type

[**CompanyCertInfoList**](CompanyCertInfoList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

