# RoomMembershipApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1RoomIdMembershipAddPost**](RoomMembershipApi.md#v1RoomIdMembershipAddPost) | **POST** /v1/room/{id}/membership/add | Adds new member to an existing room.
[**v1RoomIdMembershipDemoteOwnerPost**](RoomMembershipApi.md#v1RoomIdMembershipDemoteOwnerPost) | **POST** /v1/room/{id}/membership/demoteOwner | Demotes room owner.
[**v1RoomIdMembershipListGet**](RoomMembershipApi.md#v1RoomIdMembershipListGet) | **GET** /v1/room/{id}/membership/list | Lists the members of an existing room.
[**v1RoomIdMembershipPromoteOwnerPost**](RoomMembershipApi.md#v1RoomIdMembershipPromoteOwnerPost) | **POST** /v1/room/{id}/membership/promoteOwner | Promotes user to owner.
[**v1RoomIdMembershipRemovePost**](RoomMembershipApi.md#v1RoomIdMembershipRemovePost) | **POST** /v1/room/{id}/membership/remove | Removes member from an existing room.


<a name="v1RoomIdMembershipAddPost"></a>
# **v1RoomIdMembershipAddPost**
> SuccessResponse v1RoomIdMembershipAddPost(id, payload, sessionToken)

Adds new member to an existing room.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.RoomMembershipApi;


RoomMembershipApi apiInstance = new RoomMembershipApi();
String id = "id_example"; // String | Room streamId
UserId payload = new UserId(); // UserId | 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    SuccessResponse result = apiInstance.v1RoomIdMembershipAddPost(id, payload, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling RoomMembershipApi#v1RoomIdMembershipAddPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **payload** | [**UserId**](UserId.md)|  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1RoomIdMembershipDemoteOwnerPost"></a>
# **v1RoomIdMembershipDemoteOwnerPost**
> SuccessResponse v1RoomIdMembershipDemoteOwnerPost(id, payload, sessionToken)

Demotes room owner.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.RoomMembershipApi;


RoomMembershipApi apiInstance = new RoomMembershipApi();
String id = "id_example"; // String | Room streamId
UserId payload = new UserId(); // UserId | 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    SuccessResponse result = apiInstance.v1RoomIdMembershipDemoteOwnerPost(id, payload, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling RoomMembershipApi#v1RoomIdMembershipDemoteOwnerPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **payload** | [**UserId**](UserId.md)|  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1RoomIdMembershipListGet"></a>
# **v1RoomIdMembershipListGet**
> MembershipList v1RoomIdMembershipListGet(id, sessionToken)

Lists the members of an existing room.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.RoomMembershipApi;


RoomMembershipApi apiInstance = new RoomMembershipApi();
String id = "id_example"; // String | Room streamId
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    MembershipList result = apiInstance.v1RoomIdMembershipListGet(id, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling RoomMembershipApi#v1RoomIdMembershipListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**MembershipList**](MembershipList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1RoomIdMembershipPromoteOwnerPost"></a>
# **v1RoomIdMembershipPromoteOwnerPost**
> SuccessResponse v1RoomIdMembershipPromoteOwnerPost(id, payload, sessionToken)

Promotes user to owner.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.RoomMembershipApi;


RoomMembershipApi apiInstance = new RoomMembershipApi();
String id = "id_example"; // String | Room streamId
UserId payload = new UserId(); // UserId | 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    SuccessResponse result = apiInstance.v1RoomIdMembershipPromoteOwnerPost(id, payload, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling RoomMembershipApi#v1RoomIdMembershipPromoteOwnerPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **payload** | [**UserId**](UserId.md)|  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1RoomIdMembershipRemovePost"></a>
# **v1RoomIdMembershipRemovePost**
> SuccessResponse v1RoomIdMembershipRemovePost(id, payload, sessionToken)

Removes member from an existing room.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.RoomMembershipApi;


RoomMembershipApi apiInstance = new RoomMembershipApi();
String id = "id_example"; // String | Room streamId
UserId payload = new UserId(); // UserId | 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    SuccessResponse result = apiInstance.v1RoomIdMembershipRemovePost(id, payload, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling RoomMembershipApi#v1RoomIdMembershipRemovePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Room streamId |
 **payload** | [**UserId**](UserId.md)|  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

