# PresenceApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1PresenceGet**](PresenceApi.md#v1PresenceGet) | **GET** /v1/presence | Get presence information about all company (pod) users.
[**v1UserUidPresenceGet**](PresenceApi.md#v1UserUidPresenceGet) | **GET** /v1/user/{uid}/presence | Get presence information about a particular user.


<a name="v1PresenceGet"></a>
# **v1PresenceGet**
> PresenceList v1PresenceGet(sessionToken)

Get presence information about all company (pod) users.

The returned data is taken from the in-memory cache for performance reasons which means inactive users may be omitted from the response.  All non-inactive users WILL be returned and some inactive users MAY be included. Any omitted user IS inactive. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.PresenceApi;


PresenceApi apiInstance = new PresenceApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    PresenceList result = apiInstance.v1PresenceGet(sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling PresenceApi#v1PresenceGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**PresenceList**](PresenceList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1UserUidPresenceGet"></a>
# **v1UserUidPresenceGet**
> Presence v1UserUidPresenceGet(uid, sessionToken)

Get presence information about a particular user.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.PresenceApi;


PresenceApi apiInstance = new PresenceApi();
Long uid = 789L; // Long | User ID as a decimal integer 
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    Presence result = apiInstance.v1UserUidPresenceGet(uid, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling PresenceApi#v1UserUidPresenceGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **uid** | **Long**| User ID as a decimal integer  |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**Presence**](Presence.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

