# DisclaimerApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1AdminDisclaimerDidGet**](DisclaimerApi.md#v1AdminDisclaimerDidGet) | **GET** /v1/admin/disclaimer/{did} | Get a disclaimer by disclaimer id
[**v1AdminDisclaimerDidUsersGet**](DisclaimerApi.md#v1AdminDisclaimerDidUsersGet) | **GET** /v1/admin/disclaimer/{did}/users | List all users assigned to this disclaimer
[**v1AdminDisclaimerListGet**](DisclaimerApi.md#v1AdminDisclaimerListGet) | **GET** /v1/admin/disclaimer/list | List all disclaimers for the company (pod)


<a name="v1AdminDisclaimerDidGet"></a>
# **v1AdminDisclaimerDidGet**
> Disclaimer v1AdminDisclaimerDidGet(sessionToken, did)

Get a disclaimer by disclaimer id

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.DisclaimerApi;


DisclaimerApi apiInstance = new DisclaimerApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
String did = "did_example"; // String | The ID of the entity
try {
    Disclaimer result = apiInstance.v1AdminDisclaimerDidGet(sessionToken, did);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling DisclaimerApi#v1AdminDisclaimerDidGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **did** | **String**| The ID of the entity |

### Return type

[**Disclaimer**](Disclaimer.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminDisclaimerDidUsersGet"></a>
# **v1AdminDisclaimerDidUsersGet**
> UserIdList v1AdminDisclaimerDidUsersGet(sessionToken, did)

List all users assigned to this disclaimer

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.DisclaimerApi;


DisclaimerApi apiInstance = new DisclaimerApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
String did = "did_example"; // String | The ID of the entity
try {
    UserIdList result = apiInstance.v1AdminDisclaimerDidUsersGet(sessionToken, did);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling DisclaimerApi#v1AdminDisclaimerDidUsersGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **did** | **String**| The ID of the entity |

### Return type

[**UserIdList**](UserIdList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminDisclaimerListGet"></a>
# **v1AdminDisclaimerListGet**
> DisclaimerList v1AdminDisclaimerListGet(sessionToken)

List all disclaimers for the company (pod)

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.DisclaimerApi;


DisclaimerApi apiInstance = new DisclaimerApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    DisclaimerList result = apiInstance.v1AdminDisclaimerListGet(sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling DisclaimerApi#v1AdminDisclaimerListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**DisclaimerList**](DisclaimerList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

