# ConnectionApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1ConnectionAcceptPost**](ConnectionApi.md#v1ConnectionAcceptPost) | **POST** /v1/connection/accept | Accept the connection request for the requesting user
[**v1ConnectionCreatePost**](ConnectionApi.md#v1ConnectionCreatePost) | **POST** /v1/connection/create | Sends an invitation to connect with another user
[**v1ConnectionListGet**](ConnectionApi.md#v1ConnectionListGet) | **GET** /v1/connection/list | List of requesting user&#39;s connection
[**v1ConnectionRejectPost**](ConnectionApi.md#v1ConnectionRejectPost) | **POST** /v1/connection/reject | Reject the connection request for the requesting user.
[**v1ConnectionUserUserIdInfoGet**](ConnectionApi.md#v1ConnectionUserUserIdInfoGet) | **GET** /v1/connection/user/{userId}/info | The status of the connection invitation to another user.


<a name="v1ConnectionAcceptPost"></a>
# **v1ConnectionAcceptPost**
> UserConnection v1ConnectionAcceptPost(sessionToken, connectionRequest)

Accept the connection request for the requesting user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConnectionApi;


ConnectionApi apiInstance = new ConnectionApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
UserConnectionRequest connectionRequest = new UserConnectionRequest(); // UserConnectionRequest | 
try {
    UserConnection result = apiInstance.v1ConnectionAcceptPost(sessionToken, connectionRequest);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConnectionApi#v1ConnectionAcceptPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **connectionRequest** | [**UserConnectionRequest**](UserConnectionRequest.md)|  |

### Return type

[**UserConnection**](UserConnection.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1ConnectionCreatePost"></a>
# **v1ConnectionCreatePost**
> UserConnection v1ConnectionCreatePost(sessionToken, connectionRequest)

Sends an invitation to connect with another user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConnectionApi;


ConnectionApi apiInstance = new ConnectionApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
UserConnectionRequest connectionRequest = new UserConnectionRequest(); // UserConnectionRequest | 
try {
    UserConnection result = apiInstance.v1ConnectionCreatePost(sessionToken, connectionRequest);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConnectionApi#v1ConnectionCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **connectionRequest** | [**UserConnectionRequest**](UserConnectionRequest.md)|  |

### Return type

[**UserConnection**](UserConnection.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1ConnectionListGet"></a>
# **v1ConnectionListGet**
> UserConnectionList v1ConnectionListGet(sessionToken, status, userIds)

List of requesting user&#39;s connection

This retrieves all connections of the requesting user. (i.e. both connections in which the requesting user is the sender and those in which the requesting user is the inivtee) By default, if you haven&#39;t specified the connection status to filter on, this call will only return results for both \&quot;pending_incoming\&quot; and \&quot;pending_outgoing\&quot;. You can optionally filter by userIds to further restrict the results of a specific connection status. If the users are in the same private pod, the users have an implicit connection status of \&quot;accepted\&quot;. Those users will not be returned in the response if you don&#39;t specify the connection status as \&quot;accepted\&quot; (default is \&quot;pending\&quot;) and the explicit userIds in the request. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConnectionApi;


ConnectionApi apiInstance = new ConnectionApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
String status = "status_example"; // String | Filter the connection list based on the connection status. The connection status can only be pending_incoming, pending_outgoing, accepted, rejected, or all (all of the above) 
String userIds = "userIds_example"; // String | The userIds parameter should be specified as a comma delimited list of user ids and can be used to restrict the results of a specific connection. Note that this is particularly important if the caller intends to retrieve results for implicit connection (user within the same pod). Implicit connections will not be included in the response if userId is not provided. 
try {
    UserConnectionList result = apiInstance.v1ConnectionListGet(sessionToken, status, userIds);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConnectionApi#v1ConnectionListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **status** | **String**| Filter the connection list based on the connection status. The connection status can only be pending_incoming, pending_outgoing, accepted, rejected, or all (all of the above)  | [optional] [enum: pending_incoming, pending_outgoing, accepted, rejected, all]
 **userIds** | **String**| The userIds parameter should be specified as a comma delimited list of user ids and can be used to restrict the results of a specific connection. Note that this is particularly important if the caller intends to retrieve results for implicit connection (user within the same pod). Implicit connections will not be included in the response if userId is not provided.  | [optional]

### Return type

[**UserConnectionList**](UserConnectionList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1ConnectionRejectPost"></a>
# **v1ConnectionRejectPost**
> UserConnection v1ConnectionRejectPost(sessionToken, connectionRequest)

Reject the connection request for the requesting user.

Reject the connection between the requesting user and request sender. If both users are in the same private pod, an error will be returned because both users have an implicit connection which cannot be rejected. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConnectionApi;


ConnectionApi apiInstance = new ConnectionApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
UserConnectionRequest connectionRequest = new UserConnectionRequest(); // UserConnectionRequest | 
try {
    UserConnection result = apiInstance.v1ConnectionRejectPost(sessionToken, connectionRequest);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConnectionApi#v1ConnectionRejectPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **connectionRequest** | [**UserConnectionRequest**](UserConnectionRequest.md)|  |

### Return type

[**UserConnection**](UserConnection.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1ConnectionUserUserIdInfoGet"></a>
# **v1ConnectionUserUserIdInfoGet**
> UserConnection v1ConnectionUserUserIdInfoGet(sessionToken, userId)

The status of the connection invitation to another user.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConnectionApi;


ConnectionApi apiInstance = new ConnectionApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
String userId = "userId_example"; // String | user Id
try {
    UserConnection result = apiInstance.v1ConnectionUserUserIdInfoGet(sessionToken, userId);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConnectionApi#v1ConnectionUserUserIdInfoGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **userId** | **String**| user Id |

### Return type

[**UserConnection**](UserConnection.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

