# AppEntitlementApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1AdminAppEntitlementListGet**](AppEntitlementApi.md#v1AdminAppEntitlementListGet) | **GET** /v1/admin/app/entitlement/list | Get the list of application entitlements for the company
[**v1AdminAppEntitlementListPost**](AppEntitlementApi.md#v1AdminAppEntitlementListPost) | **POST** /v1/admin/app/entitlement/list | Update the application entitlements for the company
[**v1AdminUserUidAppEntitlementListGet**](AppEntitlementApi.md#v1AdminUserUidAppEntitlementListGet) | **GET** /v1/admin/user/{uid}/app/entitlement/list | Get the list of application entitlements for this user
[**v1AdminUserUidAppEntitlementListPost**](AppEntitlementApi.md#v1AdminUserUidAppEntitlementListPost) | **POST** /v1/admin/user/{uid}/app/entitlement/list | Update the application entitlements for this user


<a name="v1AdminAppEntitlementListGet"></a>
# **v1AdminAppEntitlementListGet**
> PodAppEntitlementList v1AdminAppEntitlementListGet(sessionToken)

Get the list of application entitlements for the company

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.AppEntitlementApi;


AppEntitlementApi apiInstance = new AppEntitlementApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    PodAppEntitlementList result = apiInstance.v1AdminAppEntitlementListGet(sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling AppEntitlementApi#v1AdminAppEntitlementListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**PodAppEntitlementList**](PodAppEntitlementList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminAppEntitlementListPost"></a>
# **v1AdminAppEntitlementListPost**
> PodAppEntitlementList v1AdminAppEntitlementListPost(sessionToken, payload)

Update the application entitlements for the company

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.AppEntitlementApi;


AppEntitlementApi apiInstance = new AppEntitlementApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
PodAppEntitlementList payload = new PodAppEntitlementList(); // PodAppEntitlementList | 
try {
    PodAppEntitlementList result = apiInstance.v1AdminAppEntitlementListPost(sessionToken, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling AppEntitlementApi#v1AdminAppEntitlementListPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **payload** | [**PodAppEntitlementList**](PodAppEntitlementList.md)|  |

### Return type

[**PodAppEntitlementList**](PodAppEntitlementList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidAppEntitlementListGet"></a>
# **v1AdminUserUidAppEntitlementListGet**
> UserAppEntitlementList v1AdminUserUidAppEntitlementListGet(sessionToken, uid)

Get the list of application entitlements for this user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.AppEntitlementApi;


AppEntitlementApi apiInstance = new AppEntitlementApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer
try {
    UserAppEntitlementList result = apiInstance.v1AdminUserUidAppEntitlementListGet(sessionToken, uid);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling AppEntitlementApi#v1AdminUserUidAppEntitlementListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer |

### Return type

[**UserAppEntitlementList**](UserAppEntitlementList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidAppEntitlementListPost"></a>
# **v1AdminUserUidAppEntitlementListPost**
> UserAppEntitlementList v1AdminUserUidAppEntitlementListPost(sessionToken, uid, payload)

Update the application entitlements for this user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.AppEntitlementApi;


AppEntitlementApi apiInstance = new AppEntitlementApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer
UserAppEntitlementList payload = new UserAppEntitlementList(); // UserAppEntitlementList | 
try {
    UserAppEntitlementList result = apiInstance.v1AdminUserUidAppEntitlementListPost(sessionToken, uid, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling AppEntitlementApi#v1AdminUserUidAppEntitlementListPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer |
 **payload** | [**UserAppEntitlementList**](UserAppEntitlementList.md)|  |

### Return type

[**UserAppEntitlementList**](UserAppEntitlementList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

