# swagger-java-client

## Requirements

Building the API client library requires [Maven](https://maven.apache.org/) to be installed.

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn deploy
```

Refer to the [official documentation](https://maven.apache.org/plugins/maven-deploy-plugin/usage.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
    <groupId>io.swagger</groupId>
    <artifactId>swagger-java-client</artifactId>
    <version>1.0.0</version>
    <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
compile "io.swagger:swagger-java-client:1.0.0"
```

### Others

At first generate the JAR by executing:

    mvn package

Then manually install the following JARs:

* target/swagger-java-client-1.0.0.jar
* target/lib/*.jar

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import org.symphonyoss.symphony.pod.invoker.*;
import org.symphonyoss.symphony.pod.invoker.auth.*;
import org.symphonyoss.symphony.pod.invoker.model.*;
import org.symphonyoss.symphony.pod.api.AppEntitlementApi;

import java.io.File;
import java.util.*;

public class AppEntitlementApiExample {

    public static void main(String[] args) {
        
        AppEntitlementApi apiInstance = new AppEntitlementApi();
        String sessionToken = "sessionToken_example"; // String | Session authentication token.
        try {
            PodAppEntitlementList result = apiInstance.v1AdminAppEntitlementListGet(sessionToken);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AppEntitlementApi#v1AdminAppEntitlementListGet");
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AppEntitlementApi* | [**v1AdminAppEntitlementListGet**](docs/AppEntitlementApi.md#v1AdminAppEntitlementListGet) | **GET** /v1/admin/app/entitlement/list | Get the list of application entitlements for the company
*AppEntitlementApi* | [**v1AdminAppEntitlementListPost**](docs/AppEntitlementApi.md#v1AdminAppEntitlementListPost) | **POST** /v1/admin/app/entitlement/list | Update the application entitlements for the company
*AppEntitlementApi* | [**v1AdminUserUidAppEntitlementListGet**](docs/AppEntitlementApi.md#v1AdminUserUidAppEntitlementListGet) | **GET** /v1/admin/user/{uid}/app/entitlement/list | Get the list of application entitlements for this user
*AppEntitlementApi* | [**v1AdminUserUidAppEntitlementListPost**](docs/AppEntitlementApi.md#v1AdminUserUidAppEntitlementListPost) | **POST** /v1/admin/user/{uid}/app/entitlement/list | Update the application entitlements for this user
*ConnectionApi* | [**v1ConnectionAcceptPost**](docs/ConnectionApi.md#v1ConnectionAcceptPost) | **POST** /v1/connection/accept | Accept the connection request for the requesting user
*ConnectionApi* | [**v1ConnectionCreatePost**](docs/ConnectionApi.md#v1ConnectionCreatePost) | **POST** /v1/connection/create | Sends an invitation to connect with another user
*ConnectionApi* | [**v1ConnectionListGet**](docs/ConnectionApi.md#v1ConnectionListGet) | **GET** /v1/connection/list | List of requesting user&#39;s connection
*ConnectionApi* | [**v1ConnectionRejectPost**](docs/ConnectionApi.md#v1ConnectionRejectPost) | **POST** /v1/connection/reject | Reject the connection request for the requesting user.
*ConnectionApi* | [**v1ConnectionUserUserIdInfoGet**](docs/ConnectionApi.md#v1ConnectionUserUserIdInfoGet) | **GET** /v1/connection/user/{userId}/info | The status of the connection invitation to another user.
*DisclaimerApi* | [**v1AdminDisclaimerDidGet**](docs/DisclaimerApi.md#v1AdminDisclaimerDidGet) | **GET** /v1/admin/disclaimer/{did} | Get a disclaimer by disclaimer id
*DisclaimerApi* | [**v1AdminDisclaimerDidUsersGet**](docs/DisclaimerApi.md#v1AdminDisclaimerDidUsersGet) | **GET** /v1/admin/disclaimer/{did}/users | List all users assigned to this disclaimer
*DisclaimerApi* | [**v1AdminDisclaimerListGet**](docs/DisclaimerApi.md#v1AdminDisclaimerListGet) | **GET** /v1/admin/disclaimer/list | List all disclaimers for the company (pod)
*InfoBarriersApi* | [**v1AdminGroupGidMembershipAddPost**](docs/InfoBarriersApi.md#v1AdminGroupGidMembershipAddPost) | **POST** /v1/admin/group/{gid}/membership/add | Add members to an Information Barrier group.
*InfoBarriersApi* | [**v1AdminGroupGidMembershipListGet**](docs/InfoBarriersApi.md#v1AdminGroupGidMembershipListGet) | **GET** /v1/admin/group/{gid}/membership/list | Get the list of userids in this Information Barrier Group
*InfoBarriersApi* | [**v1AdminGroupGidMembershipRemovePost**](docs/InfoBarriersApi.md#v1AdminGroupGidMembershipRemovePost) | **POST** /v1/admin/group/{gid}/membership/remove | Remove members from an Information Barrier group
*InfoBarriersApi* | [**v1AdminGroupListGet**](docs/InfoBarriersApi.md#v1AdminGroupListGet) | **GET** /v1/admin/group/list | Get a list of all Information Barrier Groups
*InfoBarriersApi* | [**v1AdminPolicyListGet**](docs/InfoBarriersApi.md#v1AdminPolicyListGet) | **GET** /v1/admin/policy/list | Get all Information Policies
*MessageSuppressionApi* | [**v1AdminMessagesuppressionIdSuppressPost**](docs/MessageSuppressionApi.md#v1AdminMessagesuppressionIdSuppressPost) | **POST** /v1/admin/messagesuppression/{id}/suppress | Suppress a message
*PresenceApi* | [**v1PresenceGet**](docs/PresenceApi.md#v1PresenceGet) | **GET** /v1/presence | Get presence information about all company (pod) users.
*PresenceApi* | [**v1UserUidPresenceGet**](docs/PresenceApi.md#v1UserUidPresenceGet) | **GET** /v1/user/{uid}/presence | Get presence information about a particular user.
*RoomMembershipApi* | [**v1RoomIdMembershipAddPost**](docs/RoomMembershipApi.md#v1RoomIdMembershipAddPost) | **POST** /v1/room/{id}/membership/add | Adds new member to an existing room.
*RoomMembershipApi* | [**v1RoomIdMembershipDemoteOwnerPost**](docs/RoomMembershipApi.md#v1RoomIdMembershipDemoteOwnerPost) | **POST** /v1/room/{id}/membership/demoteOwner | Demotes room owner.
*RoomMembershipApi* | [**v1RoomIdMembershipListGet**](docs/RoomMembershipApi.md#v1RoomIdMembershipListGet) | **GET** /v1/room/{id}/membership/list | Lists the members of an existing room.
*RoomMembershipApi* | [**v1RoomIdMembershipPromoteOwnerPost**](docs/RoomMembershipApi.md#v1RoomIdMembershipPromoteOwnerPost) | **POST** /v1/room/{id}/membership/promoteOwner | Promotes user to owner.
*RoomMembershipApi* | [**v1RoomIdMembershipRemovePost**](docs/RoomMembershipApi.md#v1RoomIdMembershipRemovePost) | **POST** /v1/room/{id}/membership/remove | Removes member from an existing room.
*SecurityApi* | [**v1CompanycertCreatePost**](docs/SecurityApi.md#v1CompanycertCreatePost) | **POST** /v1/companycert/create | Create a company trusted or untrusted certificate
*SecurityApi* | [**v1CompanycertDeletePost**](docs/SecurityApi.md#v1CompanycertDeletePost) | **POST** /v1/companycert/delete | Delete a company certificate
*SecurityApi* | [**v1CompanycertFingerPrintGetGet**](docs/SecurityApi.md#v1CompanycertFingerPrintGetGet) | **GET** /v1/companycert/{fingerPrint}/get | Get the details of a company certificate
*SecurityApi* | [**v1CompanycertFingerPrintIssuedByGet**](docs/SecurityApi.md#v1CompanycertFingerPrintIssuedByGet) | **GET** /v1/companycert/{fingerPrint}/issuedBy | Return a list of all certificates which were verified to the cert whose fingerprint is passed. 
*SecurityApi* | [**v1CompanycertFingerPrintUpdatePost**](docs/SecurityApi.md#v1CompanycertFingerPrintUpdatePost) | **POST** /v1/companycert/{fingerPrint}/update | Update a company certificate
*SecurityApi* | [**v1CompanycertListGet**](docs/SecurityApi.md#v1CompanycertListGet) | **GET** /v1/companycert/list | List all trusted certs
*SecurityApi* | [**v1CompanycertPodmanagedListGet**](docs/SecurityApi.md#v1CompanycertPodmanagedListGet) | **GET** /v1/companycert/podmanaged/list | List all trusted certs
*SecurityApi* | [**v1CompanycertTypeListPost**](docs/SecurityApi.md#v1CompanycertTypeListPost) | **POST** /v1/companycert/type/list | List all certs of the given types
*SessionApi* | [**v1SessioninfoGet**](docs/SessionApi.md#v1SessioninfoGet) | **GET** /v1/sessioninfo | Get information about the current user&#39;s session.
*StreamsApi* | [**v1AdminImCreatePost**](docs/StreamsApi.md#v1AdminImCreatePost) | **POST** /v1/admin/im/create | Create a new single or multi party instant message conversation
*StreamsApi* | [**v1ImCreatePost**](docs/StreamsApi.md#v1ImCreatePost) | **POST** /v1/im/create | Create a new single or multi party instant message conversation between the caller and specified users.
*StreamsApi* | [**v1RoomCreatePost**](docs/StreamsApi.md#v1RoomCreatePost) | **POST** /v1/room/create | Create a new chatroom.
*StreamsApi* | [**v1RoomIdInfoGet**](docs/StreamsApi.md#v1RoomIdInfoGet) | **GET** /v1/room/{id}/info | Get information about a partcular chatroom.
*StreamsApi* | [**v1RoomIdSetActivePost**](docs/StreamsApi.md#v1RoomIdSetActivePost) | **POST** /v1/room/{id}/setActive | Deactivate or reactivate a chatroom. At creation, a new chatroom is active.
*StreamsApi* | [**v1RoomIdUpdatePost**](docs/StreamsApi.md#v1RoomIdUpdatePost) | **POST** /v1/room/{id}/update | Update the attributes of an existing chatroom.
*StreamsApi* | [**v2RoomCreatePost**](docs/StreamsApi.md#v2RoomCreatePost) | **POST** /v2/room/create | Create a new chatroom.
*StreamsApi* | [**v2RoomIdInfoGet**](docs/StreamsApi.md#v2RoomIdInfoGet) | **GET** /v2/room/{id}/info | Get information about a partcular chatroom.
*StreamsApi* | [**v2RoomIdUpdatePost**](docs/StreamsApi.md#v2RoomIdUpdatePost) | **POST** /v2/room/{id}/update | Update the attributes of an existing chatroom.
*StreamsApi* | [**v2RoomSearchPost**](docs/StreamsApi.md#v2RoomSearchPost) | **POST** /v2/room/search | Search rooms according to the specified criteria.
*SystemApi* | [**v1AdminSystemFeaturesListGet**](docs/SystemApi.md#v1AdminSystemFeaturesListGet) | **GET** /v1/admin/system/features/list | Get the full set of Symphony features available for this pod
*UserApi* | [**v1AdminUserCreatePost**](docs/UserApi.md#v1AdminUserCreatePost) | **POST** /v1/admin/user/create | Create a new user
*UserApi* | [**v1AdminUserListGet**](docs/UserApi.md#v1AdminUserListGet) | **GET** /v1/admin/user/list | Retreive a list of all users in the company (pod)
*UserApi* | [**v1AdminUserUidAvatarGet**](docs/UserApi.md#v1AdminUserUidAvatarGet) | **GET** /v1/admin/user/{uid}/avatar | Get the URL of the avatar of a particular user
*UserApi* | [**v1AdminUserUidAvatarUpdatePost**](docs/UserApi.md#v1AdminUserUidAvatarUpdatePost) | **POST** /v1/admin/user/{uid}/avatar/update | Update the avatar of a particular user
*UserApi* | [**v1AdminUserUidDelegatesGet**](docs/UserApi.md#v1AdminUserUidDelegatesGet) | **GET** /v1/admin/user/{uid}/delegates | Get the delegates assigned to a user
*UserApi* | [**v1AdminUserUidDelegatesUpdatePost**](docs/UserApi.md#v1AdminUserUidDelegatesUpdatePost) | **POST** /v1/admin/user/{uid}/delegates/update | Update the delegates assigned to a user
*UserApi* | [**v1AdminUserUidDisclaimerGet**](docs/UserApi.md#v1AdminUserUidDisclaimerGet) | **GET** /v1/admin/user/{uid}/disclaimer | Get the disclaimer assigned to a user
*UserApi* | [**v1AdminUserUidDisclaimerUpdatePost**](docs/UserApi.md#v1AdminUserUidDisclaimerUpdatePost) | **POST** /v1/admin/user/{uid}/disclaimer/update | Assign a disclaimer to a user
*UserApi* | [**v1AdminUserUidFeaturesGet**](docs/UserApi.md#v1AdminUserUidFeaturesGet) | **GET** /v1/admin/user/{uid}/features | Get the list of Symphony feature entitlements enabled for a particular user
*UserApi* | [**v1AdminUserUidFeaturesUpdatePost**](docs/UserApi.md#v1AdminUserUidFeaturesUpdatePost) | **POST** /v1/admin/user/{uid}/features/update | Update the list of Symphony feature entitlements for a particular user
*UserApi* | [**v1AdminUserUidGet**](docs/UserApi.md#v1AdminUserUidGet) | **GET** /v1/admin/user/{uid} | Retreive user details for a particular user
*UserApi* | [**v1AdminUserUidStatusGet**](docs/UserApi.md#v1AdminUserUidStatusGet) | **GET** /v1/admin/user/{uid}/status | Get the status, active or inactive, for a particular user
*UserApi* | [**v1AdminUserUidStatusUpdatePost**](docs/UserApi.md#v1AdminUserUidStatusUpdatePost) | **POST** /v1/admin/user/{uid}/status/update | Update the status of a particular user
*UserApi* | [**v1AdminUserUidUpdatePost**](docs/UserApi.md#v1AdminUserUidUpdatePost) | **POST** /v1/admin/user/{uid}/update | Update an existing user
*UsersApi* | [**v1UserGet**](docs/UsersApi.md#v1UserGet) | **GET** /v1/user | Get user information by email address.
*UsersApi* | [**v1UserNameUserNameGetGet**](docs/UsersApi.md#v1UserNameUserNameGetGet) | **GET** /v1/user/name/{userName}/get | Get user information by user (login) name.
*UsersApi* | [**v2UserGet**](docs/UsersApi.md#v2UserGet) | **GET** /v2/user | Get user information


## Documentation for Models

 - [Avatar](docs/Avatar.md)
 - [AvatarList](docs/AvatarList.md)
 - [AvatarUpdate](docs/AvatarUpdate.md)
 - [BulkActionResult](docs/BulkActionResult.md)
 - [CertInfo](docs/CertInfo.md)
 - [CertInfoItem](docs/CertInfoItem.md)
 - [CompanyCert](docs/CompanyCert.md)
 - [CompanyCertAttributes](docs/CompanyCertAttributes.md)
 - [CompanyCertDetail](docs/CompanyCertDetail.md)
 - [CompanyCertInfo](docs/CompanyCertInfo.md)
 - [CompanyCertInfoList](docs/CompanyCertInfoList.md)
 - [CompanyCertInfoListInner](docs/CompanyCertInfoListInner.md)
 - [CompanyCertStatus](docs/CompanyCertStatus.md)
 - [CompanyCertType](docs/CompanyCertType.md)
 - [CompanyCertTypeList](docs/CompanyCertTypeList.md)
 - [DelegateAction](docs/DelegateAction.md)
 - [Disclaimer](docs/Disclaimer.md)
 - [DisclaimerList](docs/DisclaimerList.md)
 - [Error](docs/Error.md)
 - [FacetedMatchCount](docs/FacetedMatchCount.md)
 - [Feature](docs/Feature.md)
 - [FeatureList](docs/FeatureList.md)
 - [Group](docs/Group.md)
 - [GroupList](docs/GroupList.md)
 - [ImmutableRoomAttributes](docs/ImmutableRoomAttributes.md)
 - [IntegerList](docs/IntegerList.md)
 - [MemberInfo](docs/MemberInfo.md)
 - [MembershipList](docs/MembershipList.md)
 - [MessageSuppressionResponse](docs/MessageSuppressionResponse.md)
 - [NameValuePair](docs/NameValuePair.md)
 - [Password](docs/Password.md)
 - [PodAppEntitlement](docs/PodAppEntitlement.md)
 - [PodAppEntitlementList](docs/PodAppEntitlementList.md)
 - [Policy](docs/Policy.md)
 - [PolicyList](docs/PolicyList.md)
 - [Presence](docs/Presence.md)
 - [PresenceList](docs/PresenceList.md)
 - [Product](docs/Product.md)
 - [ProductList](docs/ProductList.md)
 - [RoomAttributes](docs/RoomAttributes.md)
 - [RoomCreate](docs/RoomCreate.md)
 - [RoomDetail](docs/RoomDetail.md)
 - [RoomSearchCriteria](docs/RoomSearchCriteria.md)
 - [RoomSearchResults](docs/RoomSearchResults.md)
 - [RoomSystemInfo](docs/RoomSystemInfo.md)
 - [RoomTag](docs/RoomTag.md)
 - [SessionInfo](docs/SessionInfo.md)
 - [Stream](docs/Stream.md)
 - [StringId](docs/StringId.md)
 - [StringList](docs/StringList.md)
 - [SuccessResponse](docs/SuccessResponse.md)
 - [User](docs/User.md)
 - [UserAppEntitlement](docs/UserAppEntitlement.md)
 - [UserAppEntitlementList](docs/UserAppEntitlementList.md)
 - [UserAttributes](docs/UserAttributes.md)
 - [UserConnection](docs/UserConnection.md)
 - [UserConnectionList](docs/UserConnectionList.md)
 - [UserConnectionRequest](docs/UserConnectionRequest.md)
 - [UserCreate](docs/UserCreate.md)
 - [UserDetail](docs/UserDetail.md)
 - [UserId](docs/UserId.md)
 - [UserIdList](docs/UserIdList.md)
 - [UserPresence](docs/UserPresence.md)
 - [UserStatus](docs/UserStatus.md)
 - [UserSystemInfo](docs/UserSystemInfo.md)
 - [UserV2](docs/UserV2.md)
 - [V2RoomAttributes](docs/V2RoomAttributes.md)
 - [V2RoomDetail](docs/V2RoomDetail.md)


## Documentation for Authorization

All endpoints do not require authorization.
Authentication schemes defined for the API:

## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issue.

## Author



