/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.pod.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.pod.model.FacetedMatchCount;
import org.symphonyoss.symphony.pod.model.RoomSearchCriteria;
import org.symphonyoss.symphony.pod.model.V2RoomDetail;

@ApiModel(description="A list of search results and counts per search parameter.")
public class RoomSearchResults {
    @JsonProperty(value="count")
    private Long count = null;
    @JsonProperty(value="skip")
    private Integer skip = null;
    @JsonProperty(value="limit")
    private Integer limit = null;
    @JsonProperty(value="query")
    private RoomSearchCriteria query = null;
    @JsonProperty(value="rooms")
    private List<V2RoomDetail> rooms = new ArrayList<V2RoomDetail>();
    @JsonProperty(value="facetedMatchCount")
    private List<FacetedMatchCount> facetedMatchCount = new ArrayList<FacetedMatchCount>();

    public RoomSearchResults count(Long count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(example="null", value="The total number of rooms matched by the search.")
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public RoomSearchResults skip(Integer skip) {
        this.skip = skip;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of skipped results.")
    public Integer getSkip() {
        return this.skip;
    }

    public void setSkip(Integer skip) {
        this.skip = skip;
    }

    public RoomSearchResults limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of returned results.")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public RoomSearchResults query(RoomSearchCriteria query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", value="The search query that produced this result.")
    public RoomSearchCriteria getQuery() {
        return this.query;
    }

    public void setQuery(RoomSearchCriteria query) {
        this.query = query;
    }

    public RoomSearchResults rooms(List<V2RoomDetail> rooms) {
        this.rooms = rooms;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of rooms matched by the query.")
    public List<V2RoomDetail> getRooms() {
        return this.rooms;
    }

    public void setRooms(List<V2RoomDetail> rooms) {
        this.rooms = rooms;
    }

    public RoomSearchResults facetedMatchCount(List<FacetedMatchCount> facetedMatchCount) {
        this.facetedMatchCount = facetedMatchCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Detailed counts of matched rooms per search criterion.")
    public List<FacetedMatchCount> getFacetedMatchCount() {
        return this.facetedMatchCount;
    }

    public void setFacetedMatchCount(List<FacetedMatchCount> facetedMatchCount) {
        this.facetedMatchCount = facetedMatchCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomSearchResults roomSearchResults = (RoomSearchResults)o;
        return Objects.equals(this.count, roomSearchResults.count) && Objects.equals(this.skip, roomSearchResults.skip) && Objects.equals(this.limit, roomSearchResults.limit) && Objects.equals(this.query, roomSearchResults.query) && Objects.equals(this.rooms, roomSearchResults.rooms) && Objects.equals(this.facetedMatchCount, roomSearchResults.facetedMatchCount);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.skip, this.limit, this.query, this.rooms, this.facetedMatchCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomSearchResults {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    skip: ").append(this.toIndentedString(this.skip)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    facetedMatchCount: ").append(this.toIndentedString(this.facetedMatchCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

