/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.38.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.model.UserDetail;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.UserCreate;
import org.symphonyoss.symphony.pod.model.UserFilter;
import org.symphonyoss.symphony.pod.model.UserList;
import org.symphonyoss.symphony.pod.model.UserIdList;
import org.symphonyoss.symphony.pod.model.SuccessResponse;
import org.symphonyoss.symphony.pod.model.PasswordReset;
import org.symphonyoss.symphony.pod.model.AvatarList;
import org.symphonyoss.symphony.pod.model.AvatarUpdate;
import org.symphonyoss.symphony.pod.model.IntegerList;
import org.symphonyoss.symphony.pod.model.DelegateAction;
import org.symphonyoss.symphony.pod.model.Disclaimer;
import org.symphonyoss.symphony.pod.model.StringId;
import org.symphonyoss.symphony.pod.model.FeatureList;
import org.symphonyoss.symphony.pod.model.RoleList;
import org.symphonyoss.symphony.pod.model.StringList;
import org.symphonyoss.symphony.pod.model.UserStatus;
import org.symphonyoss.symphony.pod.model.UserAttributes;
import org.junit.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API tests for UserApi
 */
public class UserApiTest {

    private final UserApi api = new UserApi();

    
    /**
     * Create a new user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserCreatePostTest() throws ApiException {
        String sessionToken = null;
        UserCreate payload = null;
        // UserDetail response = api.v1AdminUserCreatePost(sessionToken, payload);

        // TODO: test validations
    }
    
    /**
     * PROVISIONAL Find a user based on attributes
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserFindPostTest() throws ApiException {
        String sessionToken = null;
        UserFilter payload = null;
        // UserList response = api.v1AdminUserFindPost(sessionToken, payload);

        // TODO: test validations
    }
    
    /**
     * Retreive a list of all users in the company (pod)
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserListGetTest() throws ApiException {
        String sessionToken = null;
        // UserIdList response = api.v1AdminUserListGet(sessionToken);

        // TODO: test validations
    }
    
    /**
     * PROVISIONAL Send a password reset email to the email address of a particular user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidActionPasswordResetPostTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        PasswordReset payload = null;
        // SuccessResponse response = api.v1AdminUserUidActionPasswordResetPost(sessionToken, uid, payload);

        // TODO: test validations
    }
    
    /**
     * Get the URL of the avatar of a particular user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidAvatarGetTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        // AvatarList response = api.v1AdminUserUidAvatarGet(sessionToken, uid);

        // TODO: test validations
    }
    
    /**
     * Update the avatar of a particular user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidAvatarUpdatePostTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        AvatarUpdate payload = null;
        // SuccessResponse response = api.v1AdminUserUidAvatarUpdatePost(sessionToken, uid, payload);

        // TODO: test validations
    }
    
    /**
     * Get the delegates assigned to a user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidDelegatesGetTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        // IntegerList response = api.v1AdminUserUidDelegatesGet(sessionToken, uid);

        // TODO: test validations
    }
    
    /**
     * Update the delegates assigned to a user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidDelegatesUpdatePostTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        DelegateAction payload = null;
        // SuccessResponse response = api.v1AdminUserUidDelegatesUpdatePost(sessionToken, uid, payload);

        // TODO: test validations
    }
    
    /**
     * Get the disclaimer assigned to a user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidDisclaimerGetTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        // Disclaimer response = api.v1AdminUserUidDisclaimerGet(sessionToken, uid);

        // TODO: test validations
    }
    
    /**
     * Assign a disclaimer to a user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidDisclaimerUpdatePostTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        StringId payload = null;
        // SuccessResponse response = api.v1AdminUserUidDisclaimerUpdatePost(sessionToken, uid, payload);

        // TODO: test validations
    }
    
    /**
     * Get the list of Symphony feature entitlements enabled for a particular user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidFeaturesGetTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        // FeatureList response = api.v1AdminUserUidFeaturesGet(sessionToken, uid);

        // TODO: test validations
    }
    
    /**
     * Update the list of Symphony feature entitlements for a particular user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidFeaturesUpdatePostTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        FeatureList payload = null;
        // SuccessResponse response = api.v1AdminUserUidFeaturesUpdatePost(sessionToken, uid, payload);

        // TODO: test validations
    }
    
    /**
     * Retreive user details for a particular user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidGetTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        // UserDetail response = api.v1AdminUserUidGet(sessionToken, uid);

        // TODO: test validations
    }
    
    /**
     * PROVISIONAL Get the list of roles assigned to a user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidRolesGetTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        // RoleList response = api.v1AdminUserUidRolesGet(sessionToken, uid);

        // TODO: test validations
    }
    
    /**
     * PROVISIONAL Update the list of roles assigned to a user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidRolesUpdatePostTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        StringList payload = null;
        // SuccessResponse response = api.v1AdminUserUidRolesUpdatePost(sessionToken, uid, payload);

        // TODO: test validations
    }
    
    /**
     * Get the status, active or inactive, for a particular user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidStatusGetTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        // UserStatus response = api.v1AdminUserUidStatusGet(sessionToken, uid);

        // TODO: test validations
    }
    
    /**
     * Update the status of a particular user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidStatusUpdatePostTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        UserStatus payload = null;
        // SuccessResponse response = api.v1AdminUserUidStatusUpdatePost(sessionToken, uid, payload);

        // TODO: test validations
    }
    
    /**
     * Update an existing user
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1AdminUserUidUpdatePostTest() throws ApiException {
        String sessionToken = null;
        Long uid = null;
        UserAttributes payload = null;
        // UserDetail response = api.v1AdminUserUidUpdatePost(sessionToken, uid, payload);

        // TODO: test validations
    }
    
}
