/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.38.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.model.UserIdList;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.Stream;
import org.symphonyoss.symphony.pod.model.RoomCreate;
import org.symphonyoss.symphony.pod.model.RoomDetail;
import org.symphonyoss.symphony.pod.model.RoomAttributes;
import org.symphonyoss.symphony.pod.model.V2RoomAttributes;
import org.symphonyoss.symphony.pod.model.V2RoomDetail;
import org.symphonyoss.symphony.pod.model.RoomSearchCriteria;
import org.symphonyoss.symphony.pod.model.RoomSearchResults;
import org.junit.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API tests for StreamsApi
 */
public class StreamsApiTest {

    private final StreamsApi api = new StreamsApi();

    
    /**
     * Create a new single or multi party instant message conversation
     *
     * At least one user ID must be provided or an error response will be sent.  The caller is implicitly included in the members of the created chat.  Duplicate users will be included in the membership of the chat but the duplication will be silently ignored.  If there is an existing IM conversation with the same set of participants then the id of that existing stream will be returned.  This method was incorrectly specified to take a query parameter in version 1.0 of this specification but now expects a JSON array of user IDs in the body of the request. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ImCreatePostTest() throws ApiException {
        UserIdList uidList = null;
        String sessionToken = null;
        // Stream response = api.v1ImCreatePost(uidList, sessionToken);

        // TODO: test validations
    }
    
    /**
     * Create a new chatroom.
     *
     * Create a new chatroom.  If no attributes are specified, the room is created as a private chatroom. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1RoomCreatePostTest() throws ApiException {
        RoomCreate payload = null;
        String sessionToken = null;
        // RoomDetail response = api.v1RoomCreatePost(payload, sessionToken);

        // TODO: test validations
    }
    
    /**
     * Get information about a partcular chatroom.
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1RoomIdInfoGetTest() throws ApiException {
        String id = null;
        String sessionToken = null;
        // RoomDetail response = api.v1RoomIdInfoGet(id, sessionToken);

        // TODO: test validations
    }
    
    /**
     * Deactivate or reactivate a chatroom. At creation, a new chatroom is active.
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1RoomIdSetActivePostTest() throws ApiException {
        String id = null;
        Boolean active = null;
        String sessionToken = null;
        // RoomDetail response = api.v1RoomIdSetActivePost(id, active, sessionToken);

        // TODO: test validations
    }
    
    /**
     * Update the attributes of an existing chatroom.
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1RoomIdUpdatePostTest() throws ApiException {
        String id = null;
        RoomAttributes payload = null;
        String sessionToken = null;
        // RoomDetail response = api.v1RoomIdUpdatePost(id, payload, sessionToken);

        // TODO: test validations
    }
    
    /**
     * Create a new chatroom.
     *
     * Create a new chatroom.  If no  attributes are specified, the room is created as a private chatroom. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v2RoomCreatePostTest() throws ApiException {
        V2RoomAttributes payload = null;
        String sessionToken = null;
        // V2RoomDetail response = api.v2RoomCreatePost(payload, sessionToken);

        // TODO: test validations
    }
    
    /**
     * Get information about a partcular chatroom.
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v2RoomIdInfoGetTest() throws ApiException {
        String id = null;
        String sessionToken = null;
        // V2RoomDetail response = api.v2RoomIdInfoGet(id, sessionToken);

        // TODO: test validations
    }
    
    /**
     * Update the attributes of an existing chatroom.
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v2RoomIdUpdatePostTest() throws ApiException {
        String id = null;
        V2RoomAttributes payload = null;
        String sessionToken = null;
        // V2RoomDetail response = api.v2RoomIdUpdatePost(id, payload, sessionToken);

        // TODO: test validations
    }
    
    /**
     * Search rooms according to the specified criteria.
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v2RoomSearchPostTest() throws ApiException {
        String sessionToken = null;
        RoomSearchCriteria query = null;
        Integer skip = null;
        Integer limit = null;
        // RoomSearchResults response = api.v2RoomSearchPost(sessionToken, query, skip, limit);

        // TODO: test validations
    }
    
}
