/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.38.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.model.PresenceList;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.Presence;
import org.junit.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API tests for PresenceApi
 */
public class PresenceApiTest {

    private final PresenceApi api = new PresenceApi();

    
    /**
     * Get presence information about all company (pod) users.
     *
     * The returned data is taken from the in-memory cache for performance reasons which means inactive users may be omitted from the response.  All non-inactive users WILL be returned and some inactive users MAY be included. Any omitted user IS inactive. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1PresenceGetTest() throws ApiException {
        String sessionToken = null;
        // PresenceList response = api.v1PresenceGet(sessionToken);

        // TODO: test validations
    }
    
    /**
     * Get presence information about a particular user.
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1UserUidPresenceGetTest() throws ApiException {
        Long uid = null;
        String sessionToken = null;
        // Presence response = api.v1UserUidPresenceGet(uid, sessionToken);

        // TODO: test validations
    }
    
    /**
     * LIMITED RELEASE Set presence information for a particular user.
     *
     * Only the following states can be set AVAILABLE BUSY ON_THE_PHONE AWAY  Attempts to set other states will result in a 403 FORBIDDEN response.  The UNDEFINED value is an error case used to represent the case if the value stored in the system cannot be represented by the values known to the API.  The other states are reserved for future use. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1UserUidPresencePostTest() throws ApiException {
        Long uid = null;
        String sessionToken = null;
        Presence presence = null;
        // Presence response = api.v1UserUidPresencePost(uid, sessionToken, presence);

        // TODO: test validations
    }
    
}
