/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.38.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.model.V1Configuration;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.V1ConfigurationSubmissionCreate;
import org.symphonyoss.symphony.pod.model.ConfigurationList;
import org.junit.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API tests for ConfigurationApi
 */
public class ConfigurationApiTest {

    private final ConfigurationApi api = new ConfigurationApi();

    
    /**
     * Gets a Configuration object.
     *
     * A caller can get a Configuration object for a given ID.  If the {configurationId} is invalid, a client error results.  If the ID is correct, then 200 is returned along with the Configuration. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ConfigurationConfigurationIdGetGetTest() throws ApiException {
        String configurationId = null;
        String sessionToken = null;
        // V1Configuration response = api.v1ConfigurationConfigurationIdGetGet(configurationId, sessionToken);

        // TODO: test validations
    }
    
    /**
     * Update a Configuration object.
     *
     * A caller can update a Configuration object.  If the {configurationId} is invalid, a client error results. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ConfigurationConfigurationIdUpdatePutTest() throws ApiException {
        String configurationId = null;
        String sessionToken = null;
        V1Configuration _configuration = null;
        // V1Configuration response = api.v1ConfigurationConfigurationIdUpdatePut(configurationId, sessionToken, _configuration);

        // TODO: test validations
    }
    
    /**
     * Create a Configuration object.
     *
     * A caller can create a Configuration object. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ConfigurationCreatePostTest() throws ApiException {
        String sessionToken = null;
        V1ConfigurationSubmissionCreate _configuration = null;
        // V1Configuration response = api.v1ConfigurationCreatePost(sessionToken, _configuration);

        // TODO: test validations
    }
    
    /**
     * Gets a list of Configurations.
     *
     * A caller can get all Configuration objects.  If there are no Configurations to return, a 204 response will be returned. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void v1ConfigurationListGetTest() throws ApiException {
        String sessionToken = null;
        Integer offset = null;
        Integer limit = null;
        // ConfigurationList response = api.v1ConfigurationListGet(sessionToken, offset, limit);

        // TODO: test validations
    }
    
}
