/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.38.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * User Status Information.
 */
@ApiModel(description = "User Status Information.")
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-08-11T19:01:54.668-04:00")
public class UserSystemInfo   {
  @JsonProperty("id")
  private Long id = null;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    ENABLED("ENABLED"),
    
    DISABLED("DISABLED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("createdDate")
  private Long createdDate = null;

  @JsonProperty("createdBy")
  private String createdBy = null;

  @JsonProperty("lastUpdatedDate")
  private Long lastUpdatedDate = null;

  @JsonProperty("lastLoginDate")
  private Long lastLoginDate = null;

  @JsonProperty("lastPasswordReset")
  private Long lastPasswordReset = null;

  public UserSystemInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(example = "null", value = "")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public UserSystemInfo status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @ApiModelProperty(example = "null", value = "")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public UserSystemInfo createdDate(Long createdDate) {
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Get createdDate
   * @return createdDate
  **/
  @ApiModelProperty(example = "null", value = "")
  public Long getCreatedDate() {
    return createdDate;
  }

  public void setCreatedDate(Long createdDate) {
    this.createdDate = createdDate;
  }

  public UserSystemInfo createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * Get createdBy
   * @return createdBy
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public UserSystemInfo lastUpdatedDate(Long lastUpdatedDate) {
    this.lastUpdatedDate = lastUpdatedDate;
    return this;
  }

   /**
   * Get lastUpdatedDate
   * @return lastUpdatedDate
  **/
  @ApiModelProperty(example = "null", value = "")
  public Long getLastUpdatedDate() {
    return lastUpdatedDate;
  }

  public void setLastUpdatedDate(Long lastUpdatedDate) {
    this.lastUpdatedDate = lastUpdatedDate;
  }

  public UserSystemInfo lastLoginDate(Long lastLoginDate) {
    this.lastLoginDate = lastLoginDate;
    return this;
  }

   /**
   * Get lastLoginDate
   * @return lastLoginDate
  **/
  @ApiModelProperty(example = "null", value = "")
  public Long getLastLoginDate() {
    return lastLoginDate;
  }

  public void setLastLoginDate(Long lastLoginDate) {
    this.lastLoginDate = lastLoginDate;
  }

  public UserSystemInfo lastPasswordReset(Long lastPasswordReset) {
    this.lastPasswordReset = lastPasswordReset;
    return this;
  }

   /**
   * Get lastPasswordReset
   * @return lastPasswordReset
  **/
  @ApiModelProperty(example = "null", value = "")
  public Long getLastPasswordReset() {
    return lastPasswordReset;
  }

  public void setLastPasswordReset(Long lastPasswordReset) {
    this.lastPasswordReset = lastPasswordReset;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserSystemInfo userSystemInfo = (UserSystemInfo) o;
    return Objects.equals(this.id, userSystemInfo.id) &&
        Objects.equals(this.status, userSystemInfo.status) &&
        Objects.equals(this.createdDate, userSystemInfo.createdDate) &&
        Objects.equals(this.createdBy, userSystemInfo.createdBy) &&
        Objects.equals(this.lastUpdatedDate, userSystemInfo.lastUpdatedDate) &&
        Objects.equals(this.lastLoginDate, userSystemInfo.lastLoginDate) &&
        Objects.equals(this.lastPasswordReset, userSystemInfo.lastPasswordReset);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, status, createdDate, createdBy, lastUpdatedDate, lastLoginDate, lastPasswordReset);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserSystemInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    lastUpdatedDate: ").append(toIndentedString(lastUpdatedDate)).append("\n");
    sb.append("    lastLoginDate: ").append(toIndentedString(lastLoginDate)).append("\n");
    sb.append("    lastPasswordReset: ").append(toIndentedString(lastPasswordReset)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

