/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.38.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.Avatar;
import org.symphonyoss.symphony.pod.model.IntegerList;
import org.symphonyoss.symphony.pod.model.StringList;
import org.symphonyoss.symphony.pod.model.UserAttributes;
import org.symphonyoss.symphony.pod.model.UserSystemInfo;


/**
 * Detailed User record.
 */
@ApiModel(description = "Detailed User record.")
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-08-11T19:01:54.668-04:00")
public class UserDetail   {
  @JsonProperty("userAttributes")
  private UserAttributes userAttributes = null;

  @JsonProperty("userSystemInfo")
  private UserSystemInfo userSystemInfo = null;

  @JsonProperty("features")
  private IntegerList features = null;

  @JsonProperty("apps")
  private IntegerList apps = null;

  @JsonProperty("groups")
  private IntegerList groups = null;

  @JsonProperty("roles")
  private StringList roles = null;

  @JsonProperty("disclaimers")
  private IntegerList disclaimers = null;

  @JsonProperty("avatar")
  private Avatar avatar = null;

  public UserDetail userAttributes(UserAttributes userAttributes) {
    this.userAttributes = userAttributes;
    return this;
  }

   /**
   * Get userAttributes
   * @return userAttributes
  **/
  @ApiModelProperty(example = "null", value = "")
  public UserAttributes getUserAttributes() {
    return userAttributes;
  }

  public void setUserAttributes(UserAttributes userAttributes) {
    this.userAttributes = userAttributes;
  }

  public UserDetail userSystemInfo(UserSystemInfo userSystemInfo) {
    this.userSystemInfo = userSystemInfo;
    return this;
  }

   /**
   * Get userSystemInfo
   * @return userSystemInfo
  **/
  @ApiModelProperty(example = "null", value = "")
  public UserSystemInfo getUserSystemInfo() {
    return userSystemInfo;
  }

  public void setUserSystemInfo(UserSystemInfo userSystemInfo) {
    this.userSystemInfo = userSystemInfo;
  }

  public UserDetail features(IntegerList features) {
    this.features = features;
    return this;
  }

   /**
   * Get features
   * @return features
  **/
  @ApiModelProperty(example = "null", value = "")
  public IntegerList getFeatures() {
    return features;
  }

  public void setFeatures(IntegerList features) {
    this.features = features;
  }

  public UserDetail apps(IntegerList apps) {
    this.apps = apps;
    return this;
  }

   /**
   * Get apps
   * @return apps
  **/
  @ApiModelProperty(example = "null", value = "")
  public IntegerList getApps() {
    return apps;
  }

  public void setApps(IntegerList apps) {
    this.apps = apps;
  }

  public UserDetail groups(IntegerList groups) {
    this.groups = groups;
    return this;
  }

   /**
   * Get groups
   * @return groups
  **/
  @ApiModelProperty(example = "null", value = "")
  public IntegerList getGroups() {
    return groups;
  }

  public void setGroups(IntegerList groups) {
    this.groups = groups;
  }

  public UserDetail roles(StringList roles) {
    this.roles = roles;
    return this;
  }

   /**
   * Get roles
   * @return roles
  **/
  @ApiModelProperty(example = "null", value = "")
  public StringList getRoles() {
    return roles;
  }

  public void setRoles(StringList roles) {
    this.roles = roles;
  }

  public UserDetail disclaimers(IntegerList disclaimers) {
    this.disclaimers = disclaimers;
    return this;
  }

   /**
   * Get disclaimers
   * @return disclaimers
  **/
  @ApiModelProperty(example = "null", value = "")
  public IntegerList getDisclaimers() {
    return disclaimers;
  }

  public void setDisclaimers(IntegerList disclaimers) {
    this.disclaimers = disclaimers;
  }

  public UserDetail avatar(Avatar avatar) {
    this.avatar = avatar;
    return this;
  }

   /**
   * Get avatar
   * @return avatar
  **/
  @ApiModelProperty(example = "null", value = "")
  public Avatar getAvatar() {
    return avatar;
  }

  public void setAvatar(Avatar avatar) {
    this.avatar = avatar;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserDetail userDetail = (UserDetail) o;
    return Objects.equals(this.userAttributes, userDetail.userAttributes) &&
        Objects.equals(this.userSystemInfo, userDetail.userSystemInfo) &&
        Objects.equals(this.features, userDetail.features) &&
        Objects.equals(this.apps, userDetail.apps) &&
        Objects.equals(this.groups, userDetail.groups) &&
        Objects.equals(this.roles, userDetail.roles) &&
        Objects.equals(this.disclaimers, userDetail.disclaimers) &&
        Objects.equals(this.avatar, userDetail.avatar);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userAttributes, userSystemInfo, features, apps, groups, roles, disclaimers, avatar);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserDetail {\n");
    
    sb.append("    userAttributes: ").append(toIndentedString(userAttributes)).append("\n");
    sb.append("    userSystemInfo: ").append(toIndentedString(userSystemInfo)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    apps: ").append(toIndentedString(apps)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    disclaimers: ").append(toIndentedString(disclaimers)).append("\n");
    sb.append("    avatar: ").append(toIndentedString(avatar)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

