/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.38.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.ImmutableRoomAttributes;
import org.symphonyoss.symphony.pod.model.RoomAttributes;


/**
 * Room Creation Object. Once the chatroom is created, modify attributes and deactive/reactivate via the specific API calls.
 */
@ApiModel(description = "Room Creation Object. Once the chatroom is created, modify attributes and deactive/reactivate via the specific API calls.")
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-08-11T19:01:54.668-04:00")
public class RoomCreate   {
  @JsonProperty("roomAttributes")
  private RoomAttributes roomAttributes = null;

  @JsonProperty("immutableRoomAttributes")
  private ImmutableRoomAttributes immutableRoomAttributes = null;

  public RoomCreate roomAttributes(RoomAttributes roomAttributes) {
    this.roomAttributes = roomAttributes;
    return this;
  }

   /**
   * Get roomAttributes
   * @return roomAttributes
  **/
  @ApiModelProperty(example = "null", value = "")
  public RoomAttributes getRoomAttributes() {
    return roomAttributes;
  }

  public void setRoomAttributes(RoomAttributes roomAttributes) {
    this.roomAttributes = roomAttributes;
  }

  public RoomCreate immutableRoomAttributes(ImmutableRoomAttributes immutableRoomAttributes) {
    this.immutableRoomAttributes = immutableRoomAttributes;
    return this;
  }

   /**
   * Get immutableRoomAttributes
   * @return immutableRoomAttributes
  **/
  @ApiModelProperty(example = "null", value = "")
  public ImmutableRoomAttributes getImmutableRoomAttributes() {
    return immutableRoomAttributes;
  }

  public void setImmutableRoomAttributes(ImmutableRoomAttributes immutableRoomAttributes) {
    this.immutableRoomAttributes = immutableRoomAttributes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomCreate roomCreate = (RoomCreate) o;
    return Objects.equals(this.roomAttributes, roomCreate.roomAttributes) &&
        Objects.equals(this.immutableRoomAttributes, roomCreate.immutableRoomAttributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roomAttributes, immutableRoomAttributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomCreate {\n");
    
    sb.append("    roomAttributes: ").append(toIndentedString(roomAttributes)).append("\n");
    sb.append("    immutableRoomAttributes: ").append(toIndentedString(immutableRoomAttributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

