/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.38.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * RoomAttributes
 */
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-08-11T19:01:54.668-04:00")
public class RoomAttributes   {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("membersCanInvite")
  private Boolean membersCanInvite = null;

  @JsonProperty("discoverable")
  private Boolean discoverable = null;

  public RoomAttributes name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Room name.
   * @return name
  **/
  @ApiModelProperty(example = "null", value = "Room name.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public RoomAttributes description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Room description.
   * @return description
  **/
  @ApiModelProperty(example = "null", value = "Room description.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public RoomAttributes membersCanInvite(Boolean membersCanInvite) {
    this.membersCanInvite = membersCanInvite;
    return this;
  }

   /**
   * If true, any chatroom participant can add new participants. If false, only owners can add new participants.
   * @return membersCanInvite
  **/
  @ApiModelProperty(example = "null", value = "If true, any chatroom participant can add new participants. If false, only owners can add new participants.")
  public Boolean getMembersCanInvite() {
    return membersCanInvite;
  }

  public void setMembersCanInvite(Boolean membersCanInvite) {
    this.membersCanInvite = membersCanInvite;
  }

  public RoomAttributes discoverable(Boolean discoverable) {
    this.discoverable = discoverable;
    return this;
  }

   /**
   * If true, this chatroom (name, description and messages) can be searched and listed by non-participants. If false, only participants can search this room.
   * @return discoverable
  **/
  @ApiModelProperty(example = "null", value = "If true, this chatroom (name, description and messages) can be searched and listed by non-participants. If false, only participants can search this room.")
  public Boolean getDiscoverable() {
    return discoverable;
  }

  public void setDiscoverable(Boolean discoverable) {
    this.discoverable = discoverable;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomAttributes roomAttributes = (RoomAttributes) o;
    return Objects.equals(this.name, roomAttributes.name) &&
        Objects.equals(this.description, roomAttributes.description) &&
        Objects.equals(this.membersCanInvite, roomAttributes.membersCanInvite) &&
        Objects.equals(this.discoverable, roomAttributes.discoverable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, membersCanInvite, discoverable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomAttributes {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    membersCanInvite: ").append(toIndentedString(membersCanInvite)).append("\n");
    sb.append("    discoverable: ").append(toIndentedString(discoverable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

