/**
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.38.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * The suppression state of a message
 */
@ApiModel(description = "The suppression state of a message")
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-08-11T19:01:54.668-04:00")
public class MessageSuppressionResponse   {
  @JsonProperty("messageId")
  private String messageId = null;

  @JsonProperty("suppressed")
  private Boolean suppressed = null;

  @JsonProperty("suppressionDate")
  private Long suppressionDate = null;

  public MessageSuppressionResponse messageId(String messageId) {
    this.messageId = messageId;
    return this;
  }

   /**
   * Get messageId
   * @return messageId
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getMessageId() {
    return messageId;
  }

  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }

  public MessageSuppressionResponse suppressed(Boolean suppressed) {
    this.suppressed = suppressed;
    return this;
  }

   /**
   * Get suppressed
   * @return suppressed
  **/
  @ApiModelProperty(example = "null", value = "")
  public Boolean getSuppressed() {
    return suppressed;
  }

  public void setSuppressed(Boolean suppressed) {
    this.suppressed = suppressed;
  }

  public MessageSuppressionResponse suppressionDate(Long suppressionDate) {
    this.suppressionDate = suppressionDate;
    return this;
  }

   /**
   * The date when this message was suppressed.
   * @return suppressionDate
  **/
  @ApiModelProperty(example = "null", value = "The date when this message was suppressed.")
  public Long getSuppressionDate() {
    return suppressionDate;
  }

  public void setSuppressionDate(Long suppressionDate) {
    this.suppressionDate = suppressionDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessageSuppressionResponse messageSuppressionResponse = (MessageSuppressionResponse) o;
    return Objects.equals(this.messageId, messageSuppressionResponse.messageId) &&
        Objects.equals(this.suppressed, messageSuppressionResponse.suppressed) &&
        Objects.equals(this.suppressionDate, messageSuppressionResponse.suppressionDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messageId, suppressed, suppressionDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessageSuppressionResponse {\n");
    
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    suppressed: ").append(toIndentedString(suppressed)).append("\n");
    sb.append("    suppressionDate: ").append(toIndentedString(suppressionDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

